/*
 * Decompiled with CFR 0.152.
 */
package kz.greetgo.script.model.context.act;

import java.util.ArrayList;
import java.util.List;
import kz.greetgo.script.model.context.act.ActArgDynDef;
import kz.greetgo.script.model.context.act.ActDefinition;
import kz.greetgo.script.model.translate.ValueExtType;
import kz.greetgo.script.model.update.ActArgDisplayName;
import kz.greetgo.script.model.update.ActDisplayNames;
import lombok.NonNull;

public class ActDynamicDefinition
implements ActDefinition {
    @NonNull
    public final String displayName;
    @NonNull
    public final String author;
    @NonNull
    public final String description;
    @NonNull
    public final ValueExtType srcType;
    public final ValueExtType resultValueType;
    public final String resultValueDescription;
    public final List<ActArgDynDef> arguments;
    public final boolean cancelWrite;
    public final boolean cancelRead;

    public String toString() {
        return "ActDynamicDefinition{srcType=" + this.srcType + ", displayName='" + this.displayName + "', resultValueType=" + this.resultValueType + "}";
    }

    @Override
    public boolean cancelWrite() {
        return this.cancelWrite;
    }

    @Override
    public boolean cancelRead() {
        return this.cancelRead;
    }

    @Override
    public ValueExtType resultValueType() {
        return this.resultValueType;
    }

    @Override
    public ActDisplayNames toDisplayNames() {
        ActDisplayNames ret = new ActDisplayNames();
        ret.displayName = this.displayName;
        if (this.arguments != null) {
            ret.args = new ArrayList<ActArgDisplayName>();
            for (ActArgDynDef argument : this.arguments) {
                ActArgDisplayName a = new ActArgDisplayName();
                a.argId = argument.argId;
                a.valueType = argument.valueType;
                a.nameBefore = argument.nameBefore;
                a.nameAfter = argument.nameAfter;
                ret.args.add(a);
            }
        }
        return ret;
    }

    public static ActDynamicDefinitionBuilder builder() {
        return new ActDynamicDefinitionBuilder();
    }

    public ActDynamicDefinition(@NonNull String displayName, @NonNull String author, @NonNull String description, @NonNull ValueExtType srcType, ValueExtType resultValueType, String resultValueDescription, List<ActArgDynDef> arguments, boolean cancelWrite, boolean cancelRead) {
        if (displayName == null) {
            throw new NullPointerException("displayName is marked non-null but is null");
        }
        if (author == null) {
            throw new NullPointerException("author is marked non-null but is null");
        }
        if (description == null) {
            throw new NullPointerException("description is marked non-null but is null");
        }
        if (srcType == null) {
            throw new NullPointerException("srcType is marked non-null but is null");
        }
        this.displayName = displayName;
        this.author = author;
        this.description = description;
        this.srcType = srcType;
        this.resultValueType = resultValueType;
        this.resultValueDescription = resultValueDescription;
        this.arguments = arguments;
        this.cancelWrite = cancelWrite;
        this.cancelRead = cancelRead;
    }

    public static class ActDynamicDefinitionBuilder {
        private String displayName;
        private String author;
        private String description;
        private ValueExtType srcType;
        private ValueExtType resultValueType;
        private String resultValueDescription;
        private List<ActArgDynDef> arguments;
        private boolean cancelWrite;
        private boolean cancelRead;

        ActDynamicDefinitionBuilder() {
        }

        public ActDynamicDefinitionBuilder displayName(@NonNull String displayName) {
            if (displayName == null) {
                throw new NullPointerException("displayName is marked non-null but is null");
            }
            this.displayName = displayName;
            return this;
        }

        public ActDynamicDefinitionBuilder author(@NonNull String author) {
            if (author == null) {
                throw new NullPointerException("author is marked non-null but is null");
            }
            this.author = author;
            return this;
        }

        public ActDynamicDefinitionBuilder description(@NonNull String description) {
            if (description == null) {
                throw new NullPointerException("description is marked non-null but is null");
            }
            this.description = description;
            return this;
        }

        public ActDynamicDefinitionBuilder srcType(@NonNull ValueExtType srcType) {
            if (srcType == null) {
                throw new NullPointerException("srcType is marked non-null but is null");
            }
            this.srcType = srcType;
            return this;
        }

        public ActDynamicDefinitionBuilder resultValueType(ValueExtType resultValueType) {
            this.resultValueType = resultValueType;
            return this;
        }

        public ActDynamicDefinitionBuilder resultValueDescription(String resultValueDescription) {
            this.resultValueDescription = resultValueDescription;
            return this;
        }

        public ActDynamicDefinitionBuilder arguments(List<ActArgDynDef> arguments) {
            this.arguments = arguments;
            return this;
        }

        public ActDynamicDefinitionBuilder cancelWrite(boolean cancelWrite) {
            this.cancelWrite = cancelWrite;
            return this;
        }

        public ActDynamicDefinitionBuilder cancelRead(boolean cancelRead) {
            this.cancelRead = cancelRead;
            return this;
        }

        public ActDynamicDefinition build() {
            return new ActDynamicDefinition(this.displayName, this.author, this.description, this.srcType, this.resultValueType, this.resultValueDescription, this.arguments, this.cancelWrite, this.cancelRead);
        }

        public String toString() {
            return "ActDynamicDefinition.ActDynamicDefinitionBuilder(displayName=" + this.displayName + ", author=" + this.author + ", description=" + this.description + ", srcType=" + this.srcType + ", resultValueType=" + this.resultValueType + ", resultValueDescription=" + this.resultValueDescription + ", arguments=" + this.arguments + ", cancelWrite=" + this.cancelWrite + ", cancelRead=" + this.cancelRead + ")";
        }
    }
}

