/*
 * Decompiled with CFR 0.152.
 */
package kz.greetgo.script.model.context.model.signature;

import java.util.List;
import kz.greetgo.script.ann.enums.EnumDescription;
import kz.greetgo.script.ann.enums.EnumName;

@EnumName(value="\u0422\u0438\u043f \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430")
@EnumDescription(value="\u0422\u0438\u043f \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430")
public enum MybpmFileType {
    PDF,
    DOC,
    UNKNOWN;

    private static final List<String> pdfList;
    private static final List<String> docList;

    public static MybpmFileType parse(String mimeType) {
        if (mimeType == null) {
            return UNKNOWN;
        }
        if (MybpmFileType.isPdf(mimeType = mimeType.toLowerCase())) {
            return PDF;
        }
        if (MybpmFileType.isDoc(mimeType)) {
            return DOC;
        }
        return UNKNOWN;
    }

    private static boolean isPdf(String mimeType) {
        return pdfList.contains(mimeType);
    }

    private static boolean isDoc(String mimeType) {
        return docList.contains(mimeType);
    }

    static {
        pdfList = List.of("pdf", "application/pdf");
        docList = List.of("doc", "docx", "application/vnd.openxmlformats-officedocument.wordprocessingml.document");
    }
}

