/*
 * Decompiled with CFR 0.152.
 */
package kz.greetgo.script.model.definitions.enums.extractor;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kz.greetgo.script.ann.enums.EnumDescription;
import kz.greetgo.script.ann.enums.EnumName;
import kz.greetgo.script.ann.model.ValueType;
import kz.greetgo.script.model.context.ScriptObjectContext;
import kz.greetgo.script.model.definitions.enums.EnumDefinition;
import kz.greetgo.script.model.definitions.enums.EnumValueDefinition;
import kz.greetgo.script.model.definitions.enums.EnumsDefinition;
import kz.greetgo.script.model.definitions.func.FuncDefinition;
import kz.greetgo.script.model.definitions.func.FuncGroupsDefinition;
import kz.greetgo.script.model.definitions.func.extractor.FuncGroupsDefinitionExtractor;
import kz.greetgo.script.model.definitions.object.ObjectMemberDefinition;
import kz.greetgo.script.model.definitions.object.ObjectsDefinition;
import kz.greetgo.script.model.definitions.object.extractor.ObjectsDefinitionExtractor;
import kz.greetgo.script.model.translate.ValueExtType;

public class EnumsDefinitionExtractor {
    private static final Map<Class<? extends ScriptObjectContext>, EnumsDefinition> cached = new ConcurrentHashMap<Class<? extends ScriptObjectContext>, EnumsDefinition>();

    public static void init(Class<? extends ScriptObjectContext> scriptObjectContextClass) {
        EnumsDefinitionExtractor.loadEnumsDefinition(scriptObjectContextClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EnumsDefinition loadEnumsDefinition(Class<? extends ScriptObjectContext> scriptObjectContextClass) {
        EnumsDefinition fromCache = cached.get(scriptObjectContextClass);
        if (fromCache != null) {
            return fromCache;
        }
        Map<Class<? extends ScriptObjectContext>, EnumsDefinition> map = cached;
        synchronized (map) {
            EnumsDefinition fromCache2 = cached.get(scriptObjectContextClass);
            if (fromCache2 != null) {
                return fromCache2;
            }
            EnumsDefinition load = EnumsDefinitionExtractor.load(scriptObjectContextClass);
            cached.put(scriptObjectContextClass, load);
            return load;
        }
    }

    private static <T extends ScriptObjectContext> EnumsDefinition load(Class<? extends ScriptObjectContext> scriptObjectContextClass) {
        EnumsDefinition enumsDefinition = new EnumsDefinition();
        ObjectsDefinition objectsDefinition = ObjectsDefinitionExtractor.loadObjectsDefinition(scriptObjectContextClass);
        FuncGroupsDefinition funcGroupsDefinition = FuncGroupsDefinitionExtractor.loadFuncGroupsDefinition(scriptObjectContextClass);
        funcGroupsDefinition.groups.values().stream().flatMap(x -> x.functions.values().stream()).flatMap(EnumsDefinitionExtractor::toEnumDefinitions).forEach(x -> enumsDefinition.values.put(x.nativeName, (EnumDefinition)x));
        objectsDefinition.objects.values().stream().flatMap(x -> x.members.values().stream()).flatMap(EnumsDefinitionExtractor::toEnumDefinitions).forEach(x -> enumsDefinition.values.put(x.nativeName, (EnumDefinition)x));
        return enumsDefinition;
    }

    private static Stream<EnumDefinition> toEnumDefinitions(FuncDefinition funcDefinition) {
        ArrayList<EnumDefinition> list = new ArrayList<EnumDefinition>();
        if (funcDefinition.returnDefinition != null && funcDefinition.returnDefinition.type.type == ValueType.EnumRef) {
            list.add(EnumsDefinitionExtractor.generateEnumDefinition(funcDefinition.returnDefinition.enumFullClassName, funcDefinition.returnDefinition.type.enumNativeName));
        }
        funcDefinition.args.values().stream().filter(x -> x.type.type == ValueType.EnumRef).map(x -> EnumsDefinitionExtractor.generateEnumDefinition(x.enumFullClassName, x.type.enumNativeName)).forEach(list::add);
        return list.stream();
    }

    private static Stream<EnumDefinition> toEnumDefinitions(ObjectMemberDefinition objectMemberDefinition) {
        ArrayList<EnumDefinition> list = new ArrayList<EnumDefinition>();
        if (objectMemberDefinition.fieldType != null && objectMemberDefinition.fieldType.type == ValueType.EnumRef) {
            list.add(EnumsDefinitionExtractor.generateEnumDefinition(objectMemberDefinition.enumFullClassName, objectMemberDefinition.fieldType.enumNativeName));
        }
        if (objectMemberDefinition.methodRet != null && objectMemberDefinition.methodRet.valueType.type == ValueType.EnumRef) {
            list.add(EnumsDefinitionExtractor.generateEnumDefinition(objectMemberDefinition.methodRet.enumFullClassName, objectMemberDefinition.methodRet.valueType.enumNativeName));
        }
        objectMemberDefinition.methodArgs.values().stream().filter(x -> x.type.type == ValueType.EnumRef).map(x -> EnumsDefinitionExtractor.generateEnumDefinition(x.enumFullClassName, x.type.enumNativeName)).forEach(list::add);
        return list.stream();
    }

    private static EnumDefinition generateEnumDefinition(String enumClassName, String enumNativeName) {
        Class<?> enumClass = Class.forName(enumClassName);
        if (!enumClass.isEnum()) {
            throw new RuntimeException("yM8t6gcGs8 :: \u041a\u043b\u0430\u0441\u0441 " + enumClass.getSimpleName() + " \u043d\u0435 \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u0435\u043d\u0443\u043c\u043e\u043c");
        }
        EnumName enumName = enumClass.getAnnotation(EnumName.class);
        if (enumName == null) {
            throw new RuntimeException("C1tH887pX5 :: \u041d\u0435\u0442 \u0430\u043d\u043d\u043e\u0442\u0430\u0446\u0438\u0438 EnumName \u0443 \u0435\u043d\u0443\u043c\u0430 " + enumClass.getSimpleName());
        }
        EnumDescription enumDescription = enumClass.getAnnotation(EnumDescription.class);
        if (enumDescription == null) {
            throw new RuntimeException("AT8Es2xO80 :: \u041d\u0435\u0442 \u0430\u043d\u043d\u043e\u0442\u0430\u0446\u0438\u0438 EnumDescription \u0443 \u0435\u043d\u0443\u043c\u0430 " + enumClass.getSimpleName());
        }
        EnumDefinition enumDefinition = new EnumDefinition();
        enumDefinition.name = enumName.value();
        enumDefinition.description = enumDescription.value();
        enumDefinition.nativeName = enumNativeName;
        enumDefinition.fullClassName = enumClass.getName();
        enumDefinition.type = ValueExtType.enumRef(enumNativeName);
        Arrays.stream((Enum[])enumClass.getEnumConstants()).map(EnumsDefinitionExtractor::toEnumValueDefinition).forEach(x -> enumDefinition.values.put(x.nativeName, (EnumValueDefinition)x));
        return enumDefinition;
    }

    private static EnumValueDefinition toEnumValueDefinition(Enum<?> x) {
        EnumValueDefinition enumValueDefinition = new EnumValueDefinition();
        Class<?> enumClass = x.getDeclaringClass();
        Map<Class, Annotation> map = Arrays.stream(enumClass.getField(x.name()).getAnnotations()).collect(Collectors.toMap(Annotation::annotationType, v -> v));
        EnumName enumName = (EnumName)map.get(EnumName.class);
        if (enumName == null) {
            throw new RuntimeException("hUi4wM2c75 :: \u041d\u0435\u0442 \u0430\u043d\u043d\u043e\u0442\u0430\u0446\u0438\u0438 EnumName \u0443 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u044f \u0435\u043d\u0443\u043c\u0430: " + enumClass.getSimpleName() + "." + x.name());
        }
        EnumDescription enumDescription = (EnumDescription)map.get(EnumDescription.class);
        if (enumDescription == null) {
            throw new RuntimeException("lClbVgb0kD :: \u041d\u0435\u0442 \u0430\u043d\u043d\u043e\u0442\u0430\u0446\u0438\u0438 EnumDescription \u0443 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u044f \u0435\u043d\u0443\u043c\u0430: " + enumClass.getSimpleName() + "." + x.name());
        }
        enumValueDefinition.name = enumName.value();
        enumValueDefinition.description = enumDescription.value();
        enumValueDefinition.nativeName = x.name();
        return enumValueDefinition;
    }
}

