/*
 * Decompiled with CFR 0.152.
 */
package kz.greetgo.script.model.definitions.object.extractor;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import kz.greetgo.script.ann.object.ObjectConstructor;
import kz.greetgo.script.ann.object.ObjectCreateMethodName;
import kz.greetgo.script.ann.object.ObjectDescription;
import kz.greetgo.script.ann.object.ObjectDisabled;
import kz.greetgo.script.ann.object.ObjectFieldType;
import kz.greetgo.script.ann.object.ObjectFieldUseSetter;
import kz.greetgo.script.ann.object.ObjectMethodIgnore;
import kz.greetgo.script.ann.object.ObjectMethodParamDescription;
import kz.greetgo.script.ann.object.ObjectMethodParamName;
import kz.greetgo.script.ann.object.ObjectMethodParamType;
import kz.greetgo.script.ann.object.ObjectMethodReturnDescription;
import kz.greetgo.script.ann.object.ObjectMethodReturnType;
import kz.greetgo.script.ann.object.ObjectName;
import kz.greetgo.script.ann.object.ObjectNativeName;
import kz.greetgo.script.ann.object.PersonRef;
import kz.greetgo.script.model.context.ScriptObjectContext;
import kz.greetgo.script.model.context.model.BoiRef;
import kz.greetgo.script.model.context.model.signature.MybpmFile;
import kz.greetgo.script.model.definitions.object.MethodRetDefinition;
import kz.greetgo.script.model.definitions.object.ObjectDefinition;
import kz.greetgo.script.model.definitions.object.ObjectMemberDefinition;
import kz.greetgo.script.model.definitions.object.ObjectMemberType;
import kz.greetgo.script.model.definitions.object.ObjectMethodArgDefinition;
import kz.greetgo.script.model.definitions.object.ObjectsDefinition;
import kz.greetgo.script.model.translate.ValueExtType;
import kz.greetgo.script.model.util.ValueExtTypeUtil;
import org.jetbrains.annotations.Nullable;

public class ObjectsDefinitionExtractor {
    private static final Map<Class<? extends ScriptObjectContext>, ObjectsDefinition> cached = new ConcurrentHashMap<Class<? extends ScriptObjectContext>, ObjectsDefinition>();

    public static void init(Class<? extends ScriptObjectContext> scriptObjectContextClass) {
        ObjectsDefinitionExtractor.loadObjectsDefinition(scriptObjectContextClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ObjectsDefinition loadObjectsDefinition(Class<? extends ScriptObjectContext> scriptObjectContextClass) {
        ObjectsDefinition fromCache = cached.get(scriptObjectContextClass);
        if (fromCache != null) {
            return fromCache;
        }
        Map<Class<? extends ScriptObjectContext>, ObjectsDefinition> map = cached;
        synchronized (map) {
            ObjectsDefinition fromCache2 = cached.get(scriptObjectContextClass);
            if (fromCache2 != null) {
                return fromCache2;
            }
            ObjectsDefinition load = ObjectsDefinitionExtractor.load(scriptObjectContextClass);
            cached.put(scriptObjectContextClass, load);
            return load;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static ObjectsDefinition loadFirstObjectsDefinition() {
        Map<Class<? extends ScriptObjectContext>, ObjectsDefinition> map = cached;
        synchronized (map) {
            return cached.values().stream().findFirst().orElse(null);
        }
    }

    private static ObjectsDefinition load(Class<? extends ScriptObjectContext> scriptObjectContextClass) {
        ObjectsDefinition objectsDefinition = new ObjectsDefinition();
        objectsDefinition.objects = Arrays.stream(scriptObjectContextClass.getDeclaredMethods()).filter(x -> x.isAnnotationPresent(ObjectConstructor.class)).map(ObjectsDefinitionExtractor::extract).collect(Collectors.toMap(k -> k.nativeName, v -> v));
        return objectsDefinition;
    }

    private static ObjectDefinition extract(Method method) {
        ObjectDefinition objectDefinition = new ObjectDefinition();
        Class<?> returnType = method.getReturnType();
        ObjectNativeName objectNativeName = returnType.getAnnotation(ObjectNativeName.class);
        if (objectNativeName == null) {
            throw new RuntimeException("\u041d\u0435\u0442 \u0430\u043d\u043d\u043e\u0442\u0430\u0446\u0438\u0438 ObjectNativeName \u0443 \u043a\u043b\u0430\u0441\u0441\u0430 " + returnType.getName());
        }
        ObjectName objectName = returnType.getAnnotation(ObjectName.class);
        if (objectName == null) {
            throw new RuntimeException("\u041d\u0435\u0442 \u0430\u043d\u043d\u043e\u0442\u0430\u0446\u0438\u0438 ObjectName \u0443 \u043a\u043b\u0430\u0441\u0441\u0430 " + returnType.getName());
        }
        ObjectDescription objectDescription = returnType.getAnnotation(ObjectDescription.class);
        if (objectDescription == null) {
            throw new RuntimeException("\u041d\u0435\u0442 \u0430\u043d\u043d\u043e\u0442\u0430\u0446\u0438\u0438 ObjectDescription \u0443 \u043a\u043b\u0430\u0441\u0441\u0430 " + returnType.getName());
        }
        ObjectCreateMethodName objectCreateMethodName = returnType.getAnnotation(ObjectCreateMethodName.class);
        Object createMethodName = objectCreateMethodName != null ? objectCreateMethodName.value() : "create" + objectNativeName.value();
        boolean disabled = method.isAnnotationPresent(ObjectDisabled.class);
        objectDefinition.name = objectName.value();
        objectDefinition.description = objectDescription.value();
        objectDefinition.nativeName = objectNativeName.value();
        objectDefinition.disabled = disabled;
        objectDefinition.createMethodName = createMethodName;
        objectDefinition.isFile = MybpmFile.class.equals(returnType);
        Map<String, ObjectMemberDefinition> members = Arrays.stream(returnType.getDeclaredFields()).filter(x -> Modifier.isPublic(x.getModifiers())).map(x -> ObjectsDefinitionExtractor.toObjectMemberDefinition(x, returnType.getSimpleName())).filter(Objects::nonNull).collect(Collectors.toMap(k -> k.nativeName, v -> v));
        Arrays.stream(returnType.getDeclaredMethods()).filter(x -> Modifier.isPublic(x.getModifiers())).filter(x -> !x.isAnnotationPresent(ObjectMethodIgnore.class)).map(x -> ObjectsDefinitionExtractor.toObjectMemberDefinition(x, returnType.getSimpleName())).forEach(x -> members.put(x.nativeName, (ObjectMemberDefinition)x));
        objectDefinition.members = members;
        return objectDefinition;
    }

    private static ObjectMemberDefinition toObjectMemberDefinition(Field field, String classSimpleName) {
        ObjectMemberDefinition objectMemberDefinition = new ObjectMemberDefinition();
        String fieldPath = classSimpleName + "." + field.getName();
        ObjectName objectName = field.getAnnotation(ObjectName.class);
        if (objectName == null) {
            return null;
        }
        ObjectDescription objectDescription = field.getAnnotation(ObjectDescription.class);
        if (objectDescription == null) {
            throw new RuntimeException("\u041d\u0435\u0442 \u0430\u043d\u043d\u043e\u0442\u0430\u0446\u0438\u0438 ObjectDescription \u0443 \u043f\u043e\u043b\u044f " + fieldPath);
        }
        Class<?> type = field.getType();
        objectMemberDefinition.name = objectName.value();
        objectMemberDefinition.description = objectDescription.value();
        objectMemberDefinition.nativeName = field.getName();
        objectMemberDefinition.enumFullClassName = type.isEnum() ? type.getName() : null;
        objectMemberDefinition.memberType = ObjectMemberType.FIELD;
        objectMemberDefinition.fieldType = ObjectsDefinitionExtractor.toValueExtTypeFromField(field, fieldPath);
        objectMemberDefinition.fieldReadonly = Modifier.isFinal(field.getModifiers());
        objectMemberDefinition.isPersonBo = objectMemberDefinition.fieldType.isPersonBo;
        objectMemberDefinition.useSetter = field.isAnnotationPresent(ObjectFieldUseSetter.class);
        return objectMemberDefinition;
    }

    private static ObjectMemberDefinition toObjectMemberDefinition(Method method, String classSimpleName) {
        ObjectMemberDefinition objectMemberDefinition = new ObjectMemberDefinition();
        String methodPath = classSimpleName + "." + method.getName();
        ObjectName objectName = method.getAnnotation(ObjectName.class);
        if (objectName == null) {
            throw new RuntimeException("4e0Gg03AbL \u041d\u0435\u0442 \u0430\u043d\u043d\u043e\u0442\u0430\u0446\u0438\u0438 ObjectName \u0443 \u043c\u0435\u0442\u043e\u0434\u0430 " + methodPath);
        }
        ObjectDescription objectDescription = method.getAnnotation(ObjectDescription.class);
        if (objectDescription == null) {
            throw new RuntimeException("OiiMl75WcG \u041d\u0435\u0442 \u0430\u043d\u043d\u043e\u0442\u0430\u0446\u0438\u0438 ObjectDescription \u0443 \u043c\u0435\u0442\u043e\u0434\u0430 " + methodPath);
        }
        objectMemberDefinition.name = objectName.value();
        objectMemberDefinition.description = objectDescription.value();
        objectMemberDefinition.nativeName = method.getName();
        objectMemberDefinition.memberType = ObjectMemberType.METHOD;
        if (method.getGenericReturnType() != Void.TYPE) {
            ObjectMethodReturnDescription objectMethodReturnDescription = method.getAnnotation(ObjectMethodReturnDescription.class);
            if (objectMethodReturnDescription == null) {
                throw new RuntimeException("193XO206V5 :: \u041d\u0435\u0442 \u0430\u043d\u043d\u043e\u0442\u0430\u0446\u0438\u0438 ObjectMethodReturnDescription \u0443 \u0432\u043e\u0437\u0432\u0440\u0430\u0449\u0430\u0435\u043c\u043e\u0433\u043e \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u0430, \u043c\u0435\u0442\u043e\u0434\u0430 " + methodPath);
            }
            Class<?> returnType = method.getReturnType();
            MethodRetDefinition methodRetDefinition = new MethodRetDefinition();
            methodRetDefinition.description = objectMethodReturnDescription.value();
            methodRetDefinition.enumFullClassName = returnType.isEnum() ? returnType.getName() : null;
            methodRetDefinition.valueType = ObjectsDefinitionExtractor.toValueExtTypeFromReturnType(method, methodPath);
            objectMemberDefinition.methodRet = methodRetDefinition;
        }
        Annotation[][] parameterAnnotations = method.getParameterAnnotations();
        for (int i = 0; i < method.getParameterCount(); ++i) {
            objectMemberDefinition.methodArgs.put("a" + i, ObjectsDefinitionExtractor.toObjectMethodArgDefinition(method, i, parameterAnnotations[i], methodPath));
        }
        return objectMemberDefinition;
    }

    private static ObjectMethodArgDefinition toObjectMethodArgDefinition(Method method, int parameterIndex, Annotation[] parameterAnnotations, String methodPath) {
        ObjectMethodArgDefinition objectMethodArgDefinition = new ObjectMethodArgDefinition();
        Map<Class, Annotation> map = Arrays.stream(parameterAnnotations).collect(Collectors.toMap(Annotation::annotationType, v -> v));
        ObjectMethodParamName parameterName = (ObjectMethodParamName)map.get(ObjectMethodParamName.class);
        if (parameterName == null) {
            throw new RuntimeException("9W7250HK1N :: \u043d\u0435\u0442 \u0430\u043d\u043d\u043e\u0442\u0430\u0446\u0438\u0438 ObjectMethodParamName \u0443 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 \u0441 \u0438\u043d\u0434\u0435\u043a\u0441\u043e\u043c " + parameterIndex + " \u0443 \u043c\u0435\u0442\u043e\u0434\u0430 " + methodPath);
        }
        ObjectMethodParamDescription parameterDescription = (ObjectMethodParamDescription)map.get(ObjectMethodParamDescription.class);
        if (parameterDescription == null) {
            throw new RuntimeException("2RVFWhgQJJ :: \u043d\u0435\u0442 \u0430\u043d\u043d\u043e\u0442\u0430\u0446\u0438\u0438 ObjectMethodParamDescription \u0443 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 \u0441 \u0438\u043d\u0434\u0435\u043a\u0441\u043e\u043c " + parameterIndex + " \u0443 \u043c\u0435\u0442\u043e\u0434\u0430 " + methodPath);
        }
        Parameter parameter = method.getParameters()[parameterIndex];
        Class<?> type = parameter.getType();
        objectMethodArgDefinition.name = parameterName.value();
        objectMethodArgDefinition.enumFullClassName = type.isEnum() ? type.getName() : null;
        objectMethodArgDefinition.description = parameterDescription.value();
        objectMethodArgDefinition.nativeIndex = parameterIndex;
        objectMethodArgDefinition.type = ObjectsDefinitionExtractor.toValueExtTypeFromMethodParameter(parameter, methodPath);
        return objectMethodArgDefinition;
    }

    private static ValueExtType toValueExtTypeFromField(Field field, String path) {
        Class<?> fieldClass = field.getType();
        ValueExtType valueExtType = ValueExtTypeUtil.fromSimpleToValueExtType(fieldClass);
        if (valueExtType != null) {
            return valueExtType;
        }
        valueExtType = ObjectsDefinitionExtractor.getValueExtTypeFromObjects(fieldClass);
        if (valueExtType != null) {
            return valueExtType;
        }
        Map<Class, Annotation> annotationMap = Arrays.stream(field.getAnnotations()).collect(Collectors.toMap(Annotation::annotationType, v -> v));
        if (Objects.equals(BoiRef.class, fieldClass)) {
            ObjectFieldType objectFieldType = (ObjectFieldType)annotationMap.get(ObjectFieldType.class);
            if (objectFieldType == null) {
                throw new RuntimeException("lCvrTBL1su :: \u043d\u0435\u0442 \u0430\u043d\u043d\u043e\u0442\u0430\u0446\u0438\u0438 ObjectFieldType \u0443 \u0432\u043e\u0437\u0432\u0440\u0430\u0449\u0430\u0435\u043c\u043e\u0433\u043e \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u0430 \u0434\u043b\u044f \u043a\u043b\u0430\u0441\u0441\u0430 " + fieldClass.getSimpleName() + " \u043f\u043e\u043b\u044f: " + path);
            }
            ValueExtType extType = ValueExtType.single(objectFieldType.value());
            if (annotationMap.containsKey(PersonRef.class)) {
                extType.isPersonBo = true;
            }
            return extType;
        }
        if (List.class.equals(fieldClass)) {
            Type[] types = ((ParameterizedType)field.getAnnotatedType().getType()).getActualTypeArguments();
            if (types.length != 1) {
                throw new RuntimeException("5O8nGkJU4z :: \u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043f\u0440\u043e\u0447\u0438\u0442\u0430\u0442\u044c generic class List-\u0430");
            }
            Type type = types[0];
            if (!(type instanceof Class)) {
                throw new RuntimeException("dwv0s30AaE :: Cannot cast type into class");
            }
            Class innerGenericClass = (Class)type;
            if (BoiRef.class.equals((Object)innerGenericClass)) {
                ObjectFieldType objectFieldType = (ObjectFieldType)annotationMap.get(ObjectFieldType.class);
                if (objectFieldType == null) {
                    throw new RuntimeException("hL9oOIA8Tb :: \u043d\u0435\u0442 \u0430\u043d\u043d\u043e\u0442\u0430\u0446\u0438\u0438 ObjectFieldType \u0443 \u0432\u043e\u0437\u0432\u0440\u0430\u0449\u0430\u0435\u043c\u043e\u0433\u043e \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u0430 \u0434\u043b\u044f \u043a\u043b\u0430\u0441\u0441\u0430 " + innerGenericClass.getSimpleName() + ", \u043c\u0435\u0442\u043e\u0434: " + path);
                }
                return ValueExtType.multiple(objectFieldType.value());
            }
            ValueExtType innerValueExtType = ValueExtTypeUtil.fromSimpleToValueExtType(innerGenericClass);
            if (innerValueExtType != null) {
                innerValueExtType.isArray = true;
                return innerValueExtType;
            }
            innerValueExtType = ObjectsDefinitionExtractor.getValueExtTypeFromObjects(innerGenericClass);
            if (innerValueExtType != null) {
                innerValueExtType.isArray = true;
                return innerValueExtType;
            }
        }
        throw new RuntimeException("Td1B37D352 :: \u041e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u0447\u0438\u043a \u0434\u043b\u044f \u043a\u043b\u0430\u0441\u0441\u0430: " + fieldClass.getSimpleName() + ", \u043f\u0443\u0442\u044c: " + path);
    }

    private static ValueExtType toValueExtTypeFromReturnType(Method sourceMethod, String path) {
        Class<?> methodReturnClass = sourceMethod.getReturnType();
        ValueExtType valueExtType = ValueExtTypeUtil.fromSimpleToValueExtType(methodReturnClass);
        if (valueExtType != null) {
            return valueExtType;
        }
        valueExtType = ObjectsDefinitionExtractor.getValueExtTypeFromObjects(methodReturnClass);
        if (valueExtType != null) {
            return valueExtType;
        }
        Annotation[] annotations = sourceMethod.getAnnotatedReturnType().getAnnotations();
        Map<Class, Annotation> annotationMap = Arrays.stream(annotations).collect(Collectors.toMap(Annotation::annotationType, v -> v));
        if (Objects.equals(BoiRef.class, methodReturnClass)) {
            ObjectMethodReturnType objectMethodReturnType = (ObjectMethodReturnType)annotationMap.get(ObjectMethodReturnType.class);
            if (objectMethodReturnType == null) {
                throw new RuntimeException("V9XWu7BaIS :: \u043d\u0435\u0442 \u0430\u043d\u043d\u043e\u0442\u0430\u0446\u0438\u0438 ObjectMethodReturnType \u0443 \u0432\u043e\u0437\u0432\u0440\u0430\u0449\u0430\u0435\u043c\u043e\u0433\u043e \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u0430 \u0434\u043b\u044f \u043a\u043b\u0430\u0441\u0441\u0430 " + methodReturnClass.getSimpleName() + ", \u043c\u0435\u0442\u043e\u0434: " + path);
            }
            return ValueExtType.single(objectMethodReturnType.value());
        }
        if (List.class.equals(methodReturnClass)) {
            Type[] types = ((ParameterizedType)sourceMethod.getAnnotatedReturnType().getType()).getActualTypeArguments();
            if (types.length != 1) {
                throw new RuntimeException("XA8HTPYvHa :: \u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043f\u0440\u043e\u0447\u0438\u0442\u0430\u0442\u044c generic class List-\u0430");
            }
            Type type = types[0];
            if (!(type instanceof Class)) {
                throw new RuntimeException("HF8YUP068s :: Cannot cast type into class");
            }
            Class innerGenericClass = (Class)type;
            if (BoiRef.class.equals((Object)innerGenericClass)) {
                ObjectMethodReturnType objectMethodReturnType = (ObjectMethodReturnType)annotationMap.get(ObjectMethodReturnType.class);
                if (objectMethodReturnType == null) {
                    throw new RuntimeException("B0Eq8KO7tn :: \u043d\u0435\u0442 \u0430\u043d\u043d\u043e\u0442\u0430\u0446\u0438\u0438 ObjectMethodReturnType \u0443 \u0432\u043e\u0437\u0432\u0440\u0430\u0449\u0430\u0435\u043c\u043e\u0433\u043e \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u0430 \u0434\u043b\u044f \u043a\u043b\u0430\u0441\u0441\u0430 " + methodReturnClass.getSimpleName() + ", \u043c\u0435\u0442\u043e\u0434: " + path);
                }
                return ValueExtType.multiple(objectMethodReturnType.value());
            }
            ValueExtType innerValueExtType = ValueExtTypeUtil.fromSimpleToValueExtType(innerGenericClass);
            if (innerValueExtType != null) {
                innerValueExtType.isArray = true;
                return innerValueExtType;
            }
            innerValueExtType = ObjectsDefinitionExtractor.getValueExtTypeFromObjects(innerGenericClass);
            if (innerValueExtType != null) {
                innerValueExtType.isArray = true;
                return innerValueExtType;
            }
        }
        throw new RuntimeException("GY1oXDw7Hf :: \u041e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u0447\u0438\u043a \u0434\u043b\u044f \u043a\u043b\u0430\u0441\u0441\u0430 : " + methodReturnClass.getSimpleName() + ", \u043f\u0443\u0442\u044c: " + path);
    }

    private static ValueExtType toValueExtTypeFromMethodParameter(Parameter sourceParameter, String path) {
        Class<?> methodParameterClass = sourceParameter.getType();
        ValueExtType valueExtType = ValueExtTypeUtil.fromSimpleToValueExtType(methodParameterClass);
        if (valueExtType != null) {
            return valueExtType;
        }
        valueExtType = ObjectsDefinitionExtractor.getValueExtTypeFromObjects(methodParameterClass);
        if (valueExtType != null) {
            return valueExtType;
        }
        Annotation[] annotations = sourceParameter.getAnnotations();
        Map<Class, Annotation> annotationMap = Arrays.stream(annotations).collect(Collectors.toMap(Annotation::annotationType, v -> v));
        if (Objects.equals(BoiRef.class, methodParameterClass)) {
            ObjectMethodParamType objectMethodParamType = (ObjectMethodParamType)annotationMap.get(ObjectMethodParamType.class);
            if (objectMethodParamType == null) {
                throw new RuntimeException("6ytKN2VIj6 :: \u043d\u0435\u0442 \u0430\u043d\u043d\u043e\u0442\u0430\u0446\u0438\u0438 ObjectMethodParamType \u0443 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 \u0434\u043b\u044f \u043a\u043b\u0430\u0441\u0441\u0430 " + methodParameterClass.getSimpleName() + ", \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440: " + path);
            }
            return ValueExtType.single(objectMethodParamType.value());
        }
        if (List.class.equals(methodParameterClass)) {
            Type[] types = ((ParameterizedType)sourceParameter.getParameterizedType()).getActualTypeArguments();
            if (types.length != 1) {
                throw new RuntimeException("JyUx0ivD4U :: \u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043f\u0440\u043e\u0447\u0438\u0442\u0430\u0442\u044c generic class List-\u0430");
            }
            Type type = types[0];
            if (!(type instanceof Class)) {
                throw new RuntimeException("7W54sk76ta :: Cannot cast type into class");
            }
            Class innerGenericClass = (Class)type;
            if (BoiRef.class.equals((Object)innerGenericClass)) {
                ObjectMethodParamType objectMethodParamType = (ObjectMethodParamType)annotationMap.get(ObjectMethodParamType.class);
                if (objectMethodParamType == null) {
                    throw new RuntimeException("uhEW0I61KC :: \u043d\u0435\u0442 \u0430\u043d\u043d\u043e\u0442\u0430\u0446\u0438\u0438 ObjectMethodParamType \u0443 \u0432\u043e\u0437\u0432\u0440\u0430\u0449\u0430\u0435\u043c\u043e\u0433\u043e \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u0430 \u0434\u043b\u044f \u043a\u043b\u0430\u0441\u0441\u0430 " + methodParameterClass.getSimpleName() + ", \u043c\u0435\u0442\u043e\u0434: " + path);
                }
                return ValueExtType.multiple(objectMethodParamType.value());
            }
            ValueExtType innerValueExtType = ValueExtTypeUtil.fromSimpleToValueExtType(innerGenericClass);
            if (innerValueExtType != null) {
                innerValueExtType.isArray = true;
                return innerValueExtType;
            }
            innerValueExtType = ObjectsDefinitionExtractor.getValueExtTypeFromObjects(innerGenericClass);
            if (innerValueExtType != null) {
                innerValueExtType.isArray = true;
                return innerValueExtType;
            }
        }
        throw new RuntimeException("NH6jsMXauN :: \u041e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u0447\u0438\u043a \u0434\u043b\u044f \u043a\u043b\u0430\u0441\u0441\u0430 : " + methodParameterClass.getSimpleName() + ", \u043f\u0443\u0442\u044c: " + path);
    }

    @Nullable
    private static ValueExtType getValueExtTypeFromObjects(Class<?> aClass) {
        ObjectNativeName objectNativeName = aClass.getAnnotation(ObjectNativeName.class);
        if (objectNativeName == null) {
            return null;
        }
        return ValueExtType.object(objectNativeName.value());
    }
}

