/*
 * Decompiled with CFR 0.152.
 */
package kz.greetgo.script.model.expr.flow.act;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kz.greetgo.script.model.expr.flow.act.ActIdKind;
import kz.greetgo.script.model.expr.flow.act.ActIdUtil;
import kz.greetgo.script.model.expr.flow.act.ActLocalId;
import kz.greetgo.script.model.expr.flow.act.ActSourceId;

public class ActId {
    public static final String KIND = "K";
    public static final String BASE_TYPE = "T";
    public static final String FIELD_CODE = "F";
    public static final String PLUGIN_ID = "P";
    public static final String ACT_SOURCE_ID = "S";
    private static final Set<String> REGISTERED_PARAM_NAMES = Set.of("K", "T", "F", "P", "S");
    public final Map<String, String> data;

    public static ActId fix(String baseType, String fieldCode) {
        Objects.requireNonNull(baseType, "g3IPgGwY63 :: baseType");
        Objects.requireNonNull(fieldCode, "QoHvuKoWNQ :: fieldCode");
        ActIdUtil.checkOnCorrectChars(baseType, "m25q79x5Fw :: baseType");
        ActIdUtil.checkOnCorrectChars(fieldCode, "pxAZ3W6cS7 :: fieldCode");
        return new ActId(Map.of(KIND, ActIdKind.FIX.name(), BASE_TYPE, baseType, FIELD_CODE, fieldCode));
    }

    public static ActId dynamic(String sourcePluginId, String actSourceId, String fieldCode, Map<String, String> params) {
        Objects.requireNonNull(fieldCode, "ZxUhp3NE74 :: fieldCode");
        Objects.requireNonNull(actSourceId, "iS26mj1k0t :: actSourceId");
        ActIdUtil.checkOnCorrectChars(fieldCode, "yenZQqL1XG :: fieldCode");
        ActIdUtil.checkOnCorrectChars(actSourceId, "EaEM3oBxZz :: actSourceId");
        ActId.checkParamNames("82RG1oy3Cr", params);
        if (sourcePluginId != null && sourcePluginId.length() == 0) {
            sourcePluginId = null;
        }
        ActIdUtil.checkOnCorrectChars(sourcePluginId, "x0omjVYd7E :: sourcePluginId");
        HashMap<String, String> map = new HashMap<String, String>(params);
        map.putAll(ActLocalId.dyn((String)fieldCode).data);
        map.putAll(ActSourceId.of((String)sourcePluginId, (String)actSourceId).data);
        map.put(KIND, ActIdKind.DYN.name());
        return new ActId(Map.copyOf(map));
    }

    public static ActId dynamic(ActSourceId actSourceId, ActLocalId localId) {
        HashMap<String, String> data = new HashMap<String, String>(localId.data);
        String pluginId = actSourceId.pluginId();
        if (pluginId != null) {
            data.put(PLUGIN_ID, pluginId);
        }
        String localSourceId = actSourceId.localSourceId();
        data.put(ACT_SOURCE_ID, localSourceId);
        data.put(KIND, ActIdKind.DYN.name());
        return new ActId(data);
    }

    static void checkParamNames(String placeId, Map<String, String> params) {
        for (String paramName : params.keySet()) {
            ActIdUtil.checkOnCorrectChars(paramName, placeId + " :: " + paramName);
            for (String registeredParamName : REGISTERED_PARAM_NAMES) {
                if (!registeredParamName.equals(paramName)) continue;
                throw new RuntimeException(placeId + " :: You cannot use param name `" + registeredParamName + "` because it was registered for system use. Please use another param name. System parameters are: " + String.join((CharSequence)", ", REGISTERED_PARAM_NAMES));
            }
        }
    }

    public static ActId dynamic(String sourcePluginId, String actSourceId, String fieldCode) {
        return ActId.dynamic(sourcePluginId, actSourceId, fieldCode, Map.of());
    }

    public String strValue() {
        return ActIdUtil.strValue(this.data);
    }

    private static Optional<ActId> checkAndCreate(Map<String, String> data, String ... names) {
        for (String name : names) {
            if (data.containsKey(name)) continue;
            return Optional.empty();
        }
        return Optional.of(new ActId(Map.copyOf(data)));
    }

    public static Optional<ActId> parse(String strValue) {
        if (strValue == null) {
            return Optional.empty();
        }
        Map<String, String> data = ActIdUtil.parse(strValue);
        ActIdKind kind = ActIdKind.parse(data.get(KIND)).orElse(null);
        if (kind == null) {
            return Optional.empty();
        }
        switch (kind) {
            case FIX: {
                return ActId.checkAndCreate(data, BASE_TYPE, FIELD_CODE);
            }
            case DYN: {
                return ActId.checkAndCreate(data, FIELD_CODE, ACT_SOURCE_ID);
            }
        }
        return Optional.empty();
    }

    public ActIdKind kind() {
        return ActIdKind.valueOf(this.data.get(KIND));
    }

    public String baseType() {
        return this.data.get(BASE_TYPE);
    }

    public String fieldCode() {
        return this.data.get(FIELD_CODE);
    }

    public String pluginId() {
        return this.data.get(PLUGIN_ID);
    }

    public String localActSourceId() {
        return this.data.get(ACT_SOURCE_ID);
    }

    public String get(String paramName) {
        return this.data.get(paramName);
    }

    public ActSourceId actSourceId() {
        return ActSourceId.fromData(this.data);
    }

    public ActLocalId localId() {
        return ActLocalId.from(this);
    }

    public Map<String, String> restParams() {
        return this.data.entrySet().stream().filter(e -> !REGISTERED_PARAM_NAMES.contains(e.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public String toString() {
        return "ActId(data=" + this.data + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ActId)) {
            return false;
        }
        ActId other = (ActId)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<String, String> this$data = this.data;
        Map<String, String> other$data = other.data;
        return !(this$data == null ? other$data != null : !((Object)this$data).equals(other$data));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ActId;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, String> $data = this.data;
        result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
        return result;
    }

    private ActId(Map<String, String> data) {
        this.data = data;
    }
}

