/*
 * Decompiled with CFR 0.152.
 */
package kz.greetgo.script.model.expr.flow.act;

import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kz.greetgo.script.model.expr.flow.act.ActIdUtil;

public class ActSourceId {
    public final Map<String, String> data;

    public static ActSourceId fromData(Map<String, String> data) {
        return ActSourceId.of(data.get("P"), data.get("S"));
    }

    public static ActSourceId ofPlugin(String pluginId, String localActSourceId) {
        Objects.requireNonNull(pluginId, "9E68rz1mTJ :: pluginId");
        ActIdUtil.checkOnCorrectChars(pluginId, "C93zK2pW25 :: pluginId");
        Objects.requireNonNull(localActSourceId, "EHW70IoZ01 :: localActSourceId");
        ActIdUtil.checkOnCorrectChars(localActSourceId, "61HuP3iSq4 :: localActSourceId");
        return new ActSourceId(Map.of("P", pluginId, "S", localActSourceId));
    }

    public static ActSourceId ofCore(String localActSourceId) {
        Objects.requireNonNull(localActSourceId, "V7B11kYkKK :: localActSourceId");
        ActIdUtil.checkOnCorrectChars(localActSourceId, "gY5hyVfBHS :: localActSourceId");
        return new ActSourceId(Map.of("S", localActSourceId));
    }

    public static ActSourceId of(String sourcePluginId, String localSourceId) {
        return sourcePluginId == null || sourcePluginId.isEmpty() ? ActSourceId.ofCore(localSourceId) : ActSourceId.ofPlugin(sourcePluginId, localSourceId);
    }

    public String pluginId() {
        return this.data.get("P");
    }

    public String localSourceId() {
        return this.data.get("S");
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{" + this.data.entrySet().stream().sorted(Map.Entry.comparingByKey()).map(e -> (String)e.getKey() + "=`" + (String)e.getValue() + "`").collect(Collectors.joining(",")) + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ActSourceId)) {
            return false;
        }
        ActSourceId other = (ActSourceId)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<String, String> this$data = this.data;
        Map<String, String> other$data = other.data;
        return !(this$data == null ? other$data != null : !((Object)this$data).equals(other$data));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ActSourceId;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, String> $data = this.data;
        result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
        return result;
    }

    private ActSourceId(Map<String, String> data) {
        this.data = data;
    }
}

