/*
 * Decompiled with CFR 0.152.
 */
package kz.greetgo.script.model.translate;

import java.math.BigDecimal;
import java.util.Date;
import java.util.Objects;
import java.util.Set;
import kz.greetgo.kafka.model.KafkaModel;
import kz.greetgo.script.ann.model.ValueType;
import kz.greetgo.script.model.context.model.BoRef;
import kz.greetgo.script.model.context.model.BoRefCode;
import kz.greetgo.script.model.context.model.BoiFieldRef;
import kz.greetgo.script.model.context.model.BoiFieldRefCode;
import kz.greetgo.script.model.context.model.BoiRef;
import kz.greetgo.script.model.context.model.BoiRefCode;
import kz.greetgo.script.model.context.model.GeoPoint;
import kz.greetgo.script.model.context.model.Period;
import kz.greetgo.script.model.context.model.SingleSelectRef;
import kz.greetgo.script.model.context.model.SingleSelectRefCode;
import kz.greetgo.script.model.context.model.signature.MybpmFile;

@KafkaModel
public class ValueExtType {
    public String baseType;
    public ValueType type;
    public boolean isArray;
    public String boId;
    public String boCode;
    public String fieldId;
    public String fieldCode;
    public String coId;
    public Set<String> containingBoIds;
    public String instanceBoId;
    public String instanceBoiId;
    public String instanceBoiName;
    public String objectId;
    public String enumNativeName;
    public boolean isPersonBo;
    public boolean isNative;

    public static ValueExtType of(String baseType, ValueType type) {
        ValueExtType ret = new ValueExtType();
        ret.baseType = baseType;
        ret.type = type;
        return ret;
    }

    public static ValueExtType ofClass(Class<?> baseTypeClass) {
        ValueExtType ret = new ValueExtType();
        ret.baseType = baseTypeClass.getSimpleName();
        ret.type = ValueType.Object;
        return ret;
    }

    public static ValueExtType arrayOfClass(Class<?> baseTypeClass) {
        ValueExtType ret = new ValueExtType();
        ret.baseType = baseTypeClass.getSimpleName();
        ret.type = ValueType.Object;
        ret.isArray = true;
        return ret;
    }

    public static ValueExtType number() {
        ValueExtType ret = new ValueExtType();
        ret.baseType = BigDecimal.class.getSimpleName();
        ret.type = ValueType.Number;
        return ret;
    }

    public static ValueExtType mybpmFile() {
        ValueExtType ret = new ValueExtType();
        ret.baseType = MybpmFile.class.getSimpleName();
        ret.type = ValueType.File;
        ret.isArray = true;
        return ret;
    }

    public static ValueExtType text() {
        ValueExtType ret = new ValueExtType();
        ret.baseType = String.class.getSimpleName();
        ret.type = ValueType.Text;
        return ret;
    }

    public static ValueExtType date() {
        ValueExtType ret = new ValueExtType();
        ret.baseType = Date.class.getSimpleName();
        ret.type = ValueType.Date;
        return ret;
    }

    public static ValueExtType geoPoint() {
        ValueExtType ret = new ValueExtType();
        ret.baseType = GeoPoint.class.getSimpleName();
        ret.type = ValueType.GeoPoint;
        return ret;
    }

    public static ValueExtType bool() {
        ValueExtType ret = new ValueExtType();
        ret.baseType = Boolean.class.getSimpleName();
        ret.type = ValueType.Bool;
        return ret;
    }

    public static ValueExtType period() {
        ValueExtType ret = new ValueExtType();
        ret.baseType = Period.class.getSimpleName();
        ret.type = ValueType.Period;
        return ret;
    }

    public static ValueExtType boiRef() {
        ValueExtType ret = new ValueExtType();
        ret.baseType = BoiRef.class.getSimpleName();
        ret.type = ValueType.Bo;
        return ret;
    }

    public static ValueExtType boiRefCode() {
        return ValueExtType.boiRefCode(null);
    }

    public static ValueExtType boiRefCode(String boCode) {
        return ValueExtType.boiRefCode(boCode, false);
    }

    public static ValueExtType boiRefCode(String boCode, boolean isArray) {
        ValueExtType ret = new ValueExtType();
        ret.baseType = BoiRefCode.class.getSimpleName();
        ret.type = ValueType.Bo;
        ret.boCode = boCode;
        ret.isArray = isArray;
        return ret;
    }

    public static ValueExtType boiFieldRefCode() {
        return ValueExtType.boiFieldRefCode(null, null);
    }

    public static ValueExtType boiFieldRef(String boId, String fieldId) {
        ValueExtType ret = new ValueExtType();
        ret.baseType = BoiFieldRef.class.getSimpleName();
        ret.type = ValueType.BoField;
        ret.boId = boId;
        ret.fieldId = fieldId;
        return ret;
    }

    public static ValueExtType boiFieldRefCode(String boCode, String fieldCode) {
        ValueExtType ret = new ValueExtType();
        ret.baseType = BoiFieldRefCode.class.getSimpleName();
        ret.type = ValueType.Co;
        ret.boCode = boCode;
        ret.fieldCode = fieldCode;
        return ret;
    }

    public static ValueExtType boiFieldRefCode(String boCode, String fieldCode, boolean isArray) {
        ValueExtType ret = new ValueExtType();
        ret.baseType = BoiFieldRefCode.class.getSimpleName();
        ret.type = ValueType.Bo;
        ret.boCode = boCode;
        ret.fieldCode = fieldCode;
        ret.isArray = isArray;
        return ret;
    }

    public static ValueExtType boRef(String boId) {
        ValueExtType ret = new ValueExtType();
        ret.baseType = BoRef.class.getSimpleName();
        ret.boId = boId;
        ret.type = ValueType.Bo;
        return ret;
    }

    public static ValueExtType boRefCode(String boCode) {
        ValueExtType ret = new ValueExtType();
        ret.baseType = BoRefCode.class.getSimpleName();
        ret.boCode = boCode;
        ret.type = ValueType.Bo;
        return ret;
    }

    public static ValueExtType singleSelect(String boId, String fieldId) {
        ValueExtType ret = new ValueExtType();
        ret.type = ValueType.SingleSelect;
        ret.baseType = SingleSelectRef.class.getSimpleName();
        ret.boId = boId;
        ret.fieldId = fieldId;
        ret.isArray = false;
        return ret;
    }

    public static ValueExtType singleSelectCode(String boCode, String fieldCode) {
        ValueExtType ret = new ValueExtType();
        ret.type = ValueType.SingleSelect;
        ret.baseType = SingleSelectRefCode.class.getSimpleName();
        ret.boCode = boCode;
        ret.fieldCode = fieldCode;
        ret.isArray = false;
        return ret;
    }

    public ValueExtType asAlone() {
        ValueExtType ret = new ValueExtType();
        ret.baseType = this.baseType;
        ret.type = this.type;
        ret.isArray = false;
        ret.boId = this.boId;
        ret.coId = this.coId;
        ret.boCode = this.boCode;
        ret.fieldCode = this.fieldCode;
        ret.fieldId = this.fieldId;
        return ret;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName() + "{");
        sb.append(this.isArray ? "ARR " : "ONE ");
        if (this.baseType != null) {
            sb.append(this.baseType);
        } else if (this.type != null) {
            sb.append("<").append(this.type).append(">");
        }
        if (this.boId != null) {
            sb.append(", boId=").append(this.boId);
        }
        if (this.coId != null) {
            sb.append(", coId=").append(this.coId);
        }
        if (this.boCode != null) {
            sb.append(", boCode=").append(this.boCode);
        }
        if (this.fieldCode != null) {
            sb.append(", fieldCode=").append(this.fieldCode);
        }
        if (this.fieldId != null) {
            sb.append(", fieldId=").append(this.fieldId);
        }
        if (this.containingBoIds != null) {
            sb.append(", containingBoIds=").append(this.containingBoIds);
        }
        return sb.append('}').toString();
    }

    public static ValueExtType single(ValueType valueType) {
        ValueExtType ret = new ValueExtType();
        ret.type = valueType;
        ret.isArray = false;
        ret.baseType = ValueExtType.tryDetectBaseTypeByValueType(valueType);
        return ret;
    }

    private static String tryDetectBaseTypeByValueType(ValueType valueType) {
        if (valueType == null) {
            return null;
        }
        switch (valueType) {
            case Bo: 
            case Co: {
                return BoiRef.class.getSimpleName();
            }
            case Bool: {
                return Boolean.class.getSimpleName();
            }
            case Date: {
                return Date.class.getSimpleName();
            }
            case File: {
                return ValueExtType.mybpmFile().baseType;
            }
            case Text: {
                return String.class.getSimpleName();
            }
            case Number: {
                return BigDecimal.class.getSimpleName();
            }
            case Period: {
                return Period.class.getSimpleName();
            }
            case BoField: {
                return BoiFieldRef.class.getSimpleName();
            }
            case GeoPoint: {
                return GeoPoint.class.getSimpleName();
            }
            case SingleSelect: {
                return SingleSelectRef.class.getSimpleName();
            }
        }
        return null;
    }

    public static ValueExtType multiple(ValueType valueType) {
        ValueExtType ret = new ValueExtType();
        ret.type = valueType;
        ret.isArray = true;
        ret.baseType = ValueExtType.tryDetectBaseTypeByValueType(valueType);
        return ret;
    }

    public static ValueExtType bo(String boId, boolean isArray) {
        ValueExtType ret = new ValueExtType();
        ret.type = ValueType.Bo;
        ret.isArray = isArray;
        ret.boId = boId;
        return ret;
    }

    public static ValueExtType co(String coId, boolean isArray, Set<String> containingBoIds) {
        ValueExtType ret = new ValueExtType();
        ret.type = ValueType.Co;
        ret.isArray = isArray;
        ret.coId = coId;
        ret.containingBoIds = containingBoIds;
        return ret;
    }

    public static ValueExtType enumRef(String enumNativeName) {
        ValueExtType single = ValueExtType.single(ValueType.EnumRef);
        single.enumNativeName = enumNativeName;
        single.baseType = enumNativeName;
        return single;
    }

    public static ValueExtType tab() {
        return ValueExtType.single(ValueType.Tab);
    }

    public static ValueExtType object(String objectId) {
        ValueExtType single = ValueExtType.single(ValueType.Object);
        single.objectId = objectId;
        single.baseType = objectId;
        return single;
    }

    public static boolean eq(ValueExtType extType1, ValueExtType extType2) {
        if (extType1 == null && extType2 == null) {
            return true;
        }
        if (extType1 == null || extType2 == null) {
            return false;
        }
        ValueType type = extType1.type;
        if (type != extType2.type) {
            if (type == ValueType.Bo && extType2.type == ValueType.Co) {
                return extType2.containingBoIds.contains(extType1.boId);
            }
            if (type == ValueType.Co && extType2.type == ValueType.Bo) {
                return extType1.containingBoIds.contains(extType2.boId);
            }
            return false;
        }
        if (type == null) {
            return true;
        }
        switch (type) {
            case Bo: {
                return Objects.equals(extType1.boId, extType2.boId);
            }
            case Co: {
                return Objects.equals(extType1.boId, extType2.boId) && Objects.equals(extType1.containingBoIds, extType2.containingBoIds);
            }
            case Object: {
                return Objects.equals(extType1.objectId, extType2.objectId);
            }
            case EnumRef: {
                return Objects.equals(extType1.enumNativeName, extType2.enumNativeName);
            }
            case BoField: {
                return Objects.equals(extType1.boId, extType2.boId) && Objects.equals(extType1.fieldId, extType2.fieldId);
            }
            case SingleSelect: {
                return true;
            }
        }
        return true;
    }

    public static boolean eqBoCo(ValueExtType extType1, ValueExtType extType2) {
        if (extType1 == null && extType2 == null) {
            return true;
        }
        if (extType1 == null || extType2 == null) {
            return false;
        }
        ValueType type = extType1.type;
        if (type != extType2.type) {
            if (type == ValueType.Bo && extType2.type == ValueType.Co) {
                return Objects.equals(extType1.boId, extType2.coId) || extType2.containingBoIds.contains(extType1.boId);
            }
            if (type == ValueType.Co && extType2.type == ValueType.Bo) {
                return Objects.equals(extType1.coId, extType2.boId) || extType1.containingBoIds.contains(extType2.boId);
            }
        }
        return ValueExtType.eq(extType1, extType2);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ValueExtType)) {
            return false;
        }
        ValueExtType other = (ValueExtType)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isArray != other.isArray) {
            return false;
        }
        if (this.isPersonBo != other.isPersonBo) {
            return false;
        }
        if (this.isNative != other.isNative) {
            return false;
        }
        String this$baseType = this.baseType;
        String other$baseType = other.baseType;
        if (this$baseType == null ? other$baseType != null : !this$baseType.equals(other$baseType)) {
            return false;
        }
        ValueType this$type = this.type;
        ValueType other$type = other.type;
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$boId = this.boId;
        String other$boId = other.boId;
        if (this$boId == null ? other$boId != null : !this$boId.equals(other$boId)) {
            return false;
        }
        String this$boCode = this.boCode;
        String other$boCode = other.boCode;
        if (this$boCode == null ? other$boCode != null : !this$boCode.equals(other$boCode)) {
            return false;
        }
        String this$fieldId = this.fieldId;
        String other$fieldId = other.fieldId;
        if (this$fieldId == null ? other$fieldId != null : !this$fieldId.equals(other$fieldId)) {
            return false;
        }
        String this$fieldCode = this.fieldCode;
        String other$fieldCode = other.fieldCode;
        if (this$fieldCode == null ? other$fieldCode != null : !this$fieldCode.equals(other$fieldCode)) {
            return false;
        }
        String this$coId = this.coId;
        String other$coId = other.coId;
        if (this$coId == null ? other$coId != null : !this$coId.equals(other$coId)) {
            return false;
        }
        Set<String> this$containingBoIds = this.containingBoIds;
        Set<String> other$containingBoIds = other.containingBoIds;
        if (this$containingBoIds == null ? other$containingBoIds != null : !((Object)this$containingBoIds).equals(other$containingBoIds)) {
            return false;
        }
        String this$instanceBoId = this.instanceBoId;
        String other$instanceBoId = other.instanceBoId;
        if (this$instanceBoId == null ? other$instanceBoId != null : !this$instanceBoId.equals(other$instanceBoId)) {
            return false;
        }
        String this$instanceBoiId = this.instanceBoiId;
        String other$instanceBoiId = other.instanceBoiId;
        if (this$instanceBoiId == null ? other$instanceBoiId != null : !this$instanceBoiId.equals(other$instanceBoiId)) {
            return false;
        }
        String this$instanceBoiName = this.instanceBoiName;
        String other$instanceBoiName = other.instanceBoiName;
        if (this$instanceBoiName == null ? other$instanceBoiName != null : !this$instanceBoiName.equals(other$instanceBoiName)) {
            return false;
        }
        String this$objectId = this.objectId;
        String other$objectId = other.objectId;
        if (this$objectId == null ? other$objectId != null : !this$objectId.equals(other$objectId)) {
            return false;
        }
        String this$enumNativeName = this.enumNativeName;
        String other$enumNativeName = other.enumNativeName;
        return !(this$enumNativeName == null ? other$enumNativeName != null : !this$enumNativeName.equals(other$enumNativeName));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ValueExtType;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isArray ? 79 : 97);
        result = result * 59 + (this.isPersonBo ? 79 : 97);
        result = result * 59 + (this.isNative ? 79 : 97);
        String $baseType = this.baseType;
        result = result * 59 + ($baseType == null ? 43 : $baseType.hashCode());
        ValueType $type = this.type;
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $boId = this.boId;
        result = result * 59 + ($boId == null ? 43 : $boId.hashCode());
        String $boCode = this.boCode;
        result = result * 59 + ($boCode == null ? 43 : $boCode.hashCode());
        String $fieldId = this.fieldId;
        result = result * 59 + ($fieldId == null ? 43 : $fieldId.hashCode());
        String $fieldCode = this.fieldCode;
        result = result * 59 + ($fieldCode == null ? 43 : $fieldCode.hashCode());
        String $coId = this.coId;
        result = result * 59 + ($coId == null ? 43 : $coId.hashCode());
        Set<String> $containingBoIds = this.containingBoIds;
        result = result * 59 + ($containingBoIds == null ? 43 : ((Object)$containingBoIds).hashCode());
        String $instanceBoId = this.instanceBoId;
        result = result * 59 + ($instanceBoId == null ? 43 : $instanceBoId.hashCode());
        String $instanceBoiId = this.instanceBoiId;
        result = result * 59 + ($instanceBoiId == null ? 43 : $instanceBoiId.hashCode());
        String $instanceBoiName = this.instanceBoiName;
        result = result * 59 + ($instanceBoiName == null ? 43 : $instanceBoiName.hashCode());
        String $objectId = this.objectId;
        result = result * 59 + ($objectId == null ? 43 : $objectId.hashCode());
        String $enumNativeName = this.enumNativeName;
        result = result * 59 + ($enumNativeName == null ? 43 : $enumNativeName.hashCode());
        return result;
    }

    public static final class Fields {
        public static final String baseType = "baseType";
        public static final String type = "type";
        public static final String isArray = "isArray";
        public static final String boId = "boId";
        public static final String boCode = "boCode";
        public static final String fieldId = "fieldId";
        public static final String fieldCode = "fieldCode";
        public static final String coId = "coId";
        public static final String containingBoIds = "containingBoIds";
        public static final String instanceBoId = "instanceBoId";
        public static final String instanceBoiId = "instanceBoiId";
        public static final String instanceBoiName = "instanceBoiName";
        public static final String objectId = "objectId";
        public static final String enumNativeName = "enumNativeName";
        public static final String isPersonBo = "isPersonBo";
        public static final String isNative = "isNative";
    }
}

