package kz.greetgo.script.model.block.enums;

public enum BlockExitType {
  /**
   * Выйти из цикла
   * <p>
   * Аналог Java-команды: break
   */
  FROM_CIRCLE,

  /**
   * Выти из текущей итерации цикла и приступить к следующей
   * <p>
   * Аналог Java-команды: continue
   */
  FROM_CIRCLE_ITER,

  /**
   * Выйти из метода
   * <p>
   * Аналог Java-команды: return
   */
  FROM_METHOD,

  /**
   * Выйти из метода с продолжением по стрелке
   * <p>
   * Аналог Java-команды: return
   */
  FROM_METHOD_BY_ARROW,
}
