package kz.greetgo.script.model.context;

import java.util.List;
import kz.greetgo.script.model.context.diagnostic.ScriptDiagnosticMessageDto;
import lombok.AccessLevel;
import lombok.RequiredArgsConstructor;

@RequiredArgsConstructor(access = AccessLevel.PRIVATE)
public class AssembleResultOk implements AssembleResult {
  private final byte[]                           jarBytes;
  private final List<ScriptDiagnosticMessageDto> diagnosticList;

  @Override
  public boolean success() {
    return true;
  }

  @Override
  public byte[] jarBytes() {
    return jarBytes;
  }

  @Override
  public List<ScriptDiagnosticMessageDto> diagnosticList() {
    return diagnosticList;
  }

  public static AssembleResultOk of(byte[] jarBytes, List<ScriptDiagnosticMessageDto> diagnosticList) {
    return new AssembleResultOk(jarBytes, diagnosticList);
  }
}
