package kz.greetgo.script.model.context;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kz.greetgo.script.model.context.act.DynamicActInvoker;
import kz.greetgo.script.model.context.model.BoiFieldRef;
import kz.greetgo.script.model.context.model.BoiRef;
import kz.greetgo.script.model.context.model.BoiRefCode;
import kz.greetgo.script.model.context.model.GeoPoint;
import kz.greetgo.script.model.context.model.Period;
import kz.greetgo.script.model.context.model.SingleSelectRef;
import kz.greetgo.script.model.context.model.SingleSelectRefCode;
import kz.greetgo.script.model.context.model.VarDef;
import kz.greetgo.script.model.context.model.filter.CtxBoiFilter;
import kz.greetgo.script.model.context.model.signature.MybpmFile;
import kz.greetgo.script.model.context.object.ObjectFactory;
import kz.greetgo.script.model.expr.flow.FieldMetaType;
import org.bson.types.ObjectId;

public interface ScriptContext {

  String SELF = "self";

  BoiRef self();

  String THIS_PROCESS = "thisProcess";

  BoiRefCode thisProcess();

  List<VarDef> getVars(String boId);


  void setFieldAsBigDecimal(BoiRefCode boiRefCode, String fieldCode, BigDecimal value);

  BigDecimal getFieldAsBigDecimal(BoiRefCode boiRefCode, String fieldCode);


  void setFieldAsString(BoiRefCode boiRefCode, String fieldCode, String value);

  String getFieldAsString(BoiRefCode boiRefCode, String fieldCode);


  void setFieldAsBoolean(BoiRefCode boiRefCode, String fieldCode, Boolean value);

  boolean getFieldAsBoolean(BoiRefCode boiRefCode, String fieldCode);


  void setFieldAsDate(BoiRefCode boiRefCode, String fieldCode, Date value);

  Date getFieldAsDate(BoiRefCode boiRefCode, String fieldCode);


  void setFieldAsBoiRefCode(BoiRefCode boiRefCode, String fieldCode, BoiRefCode value);

  BoiRefCode getFieldAsBoiRefCode(BoiRefCode boiRefCode, String fieldCode);


  void setFieldAsBoiRefCodeList(BoiRefCode boiRefCode, String fieldCode, List<BoiRefCode> value);

  List<BoiRefCode> getFieldAsBoiRefCodeList(BoiRefCode boiRefCode, String fieldCode);


  void setFieldAsSingleSelectRefCode(BoiRefCode boiRefCode, String fieldCode, SingleSelectRefCode value);

  SingleSelectRefCode getFieldAsSingleSelectRefCode(BoiRefCode boiRefCode, String fieldCode);


  void setFieldAsGeoPoint(BoiRefCode boiRefCode, String fieldCode, GeoPoint value);

  GeoPoint getFieldAsGeoPoint(BoiRefCode boiRefCode, String fieldCode);


  void setFieldAsPeriod(BoiRefCode boiRefCode, String fieldCode, Period value);

  Period getFieldAsPeriod(BoiRefCode boiRefCode, String fieldCode);


  void setFieldAsMybpmFile(BoiRefCode boiRefCode, String fieldCode, MybpmFile value);

  MybpmFile getFieldAsMybpmFile(BoiRefCode boiRef, String fieldCode);


  void setFieldAsListMybpmFile(BoiRefCode boiRefCode, String fieldCode, List<MybpmFile> value);

  List<MybpmFile> getFieldAsListMybpmFile(BoiRefCode boiRefCode, String fieldCode);


  // --------------------


  void setVarAsBigDecimal(BoiRef boiRef, String fieldId, BigDecimal value);

  BigDecimal getVarAsBigDecimal(BoiRef boiRef, String fieldId);


  void setVarAsText(BoiRef boiRef, String fieldId, String value);

  String getVarAsText(BoiRef boiRef, String fieldId);


  void setVarAsBool(BoiRef boiRef, String fieldId, Boolean value);

  boolean getVarAsBool(BoiRef boiRef, String fieldId);


  void setVarAsDate(BoiRef boiRef, String fieldId, Date value);

  Date getVarAsDate(BoiRef boiRef, String fieldId);


  void setVarAsBoiRef(BoiRef boiRef, String fieldId, BoiRef value);

  BoiRef getVarAsBoiRef(BoiRef boiRef, String fieldId);


  void setVarAsBoiRefList(BoiRef boiRef, String fieldId, List<BoiRef> value);

  List<BoiRef> getVarAsBoiRefList(BoiRef boiRef, String fieldId);


  void setVarAsSingleSelectRef(BoiRef boiRef, String fieldId, SingleSelectRef value);

  SingleSelectRef getVarAsSingleSelectRef(BoiRef boiRef, String fieldId);


  void setVarAsGeoPointCoordinate(BoiRef boiRef, String fieldId, GeoPoint value);

  GeoPoint getVarAsGeoPointCoordinate(BoiRef boiRef, String fieldId);


  void setVarAsPeriod(BoiRef boiRef, String fieldId, Period value);

  Period getVarAsPeriod(BoiRef boiRef, String fieldId);


  void setVarAsFile(BoiRef boiRef, String fieldId, MybpmFile value);

  MybpmFile getVarAsFile(BoiRef boiRef, String fieldId);


  void setVarAsFileList(BoiRef boiRef, String fieldId, List<MybpmFile> value);

  List<MybpmFile> getVarAsFileList(BoiRef boiRef, String fieldId);

  // ------------------------------

  /**
   * Поиск инстанций бизнес-объекта по фильтру
   * <p>
   * Если указать limit > 0, то будет возвращаться список с указанным количеством инстанций, не больше.
   * <p>
   * Если указать limit <= 0, то будет возвращаться итератор, который автоматически будет загружать порции данных с сервера
   *
   * @param boId   идентификатор БО, инстанции которого ищутся
   * @param filter фильтр поиска
   * @param skip   сколько нужно вначале пропустить перед выводом
   * @param limit  ограничение вывода
   * @return итератор по найденным инстанциям или список найденных инстанций
   */
  Iterable<BoiRef> findBoi(String boId, CtxBoiFilter filter, int skip, int limit);

  BoiRef createBoi(String boId);

  @SuppressWarnings("unused")
  ScriptFuncContext funcContext();

  @SuppressWarnings("unused")
  ScriptObjectContext objectContext();

  void goForProcess(BoiRef boiRef);

  void renameFile(String fileId, String name);

  String objectFactory = "objectFactory";

  ObjectFactory objectFactory();

  String dynamicActInvoker = "dynamicActInvoker";

  DynamicActInvoker dynamicActInvoker();

  ObjectId companyId();

  boolean testMode();

  void setFieldMeta(BoiFieldRef boiFieldRef, BoiRef boiRefOrgUnit, FieldMetaType fieldMetaType, boolean value);

  void removeBoi(BoiRef boiRef);

  Map<BoiRef, Map<String, String>> boisToCreate();

}
