package kz.greetgo.script.model.context.act;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import kz.greetgo.script.model.context.ScriptContext;
import kz.greetgo.script.model.expr.flow.act.ActLocalId;
import kz.greetgo.script.model.translate.ValueExtType;
import org.bson.types.ObjectId;

public interface DynamicActSource {

  String id();

  List<ActDisplay> listRecords(ValueExtType leftExtType, ObjectId companyId, boolean testMode);

  Optional<ActDynamicDefinition> getDefinition(ValueExtType leftType, ActLocalId actLocalId, ObjectId companyId, boolean testMode);

  Object readAct(ScriptContext scriptContext, Object self, ActLocalId actLocalId, Map<String, Object> argValues);

  void writeAct(ScriptContext scriptContext, Object self, ActLocalId actLocalId, Map<String, Object> argValues, Object writeValue);

  void registerBaseTypes(BaseTypeRegistration btr);

  void checkLeftAndRightTypesAssignability(String blockAssignId, ValueExtType leftType, ValueExtType rightType, CheckMediator checkMediator);
}
