package kz.greetgo.script.model.context.model.signature;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kz.greetgo.script.ann.model.ValueType;
import kz.greetgo.script.ann.object.ObjectCreateMethodName;
import kz.greetgo.script.ann.object.ObjectDescription;
import kz.greetgo.script.ann.object.ObjectFieldType;
import kz.greetgo.script.ann.object.ObjectName;
import kz.greetgo.script.ann.object.ObjectNativeName;
import kz.greetgo.script.ann.object.PersonRef;
import kz.greetgo.script.model.context.model.BoiRef;

@ObjectName("Подпись")
@ObjectNativeName("MybpmSignature")
@ObjectCreateMethodName("createMybpmSignature")
@ObjectDescription("Подпись, у которой тип может быть как ЭЦП, так и СМС")
public class MybpmSignature {

  public String id;

  public String boId;

  public String boiId;

  @ObjectName("Дата подписи")
  @ObjectDescription("Дата подписания пользователем документов")
  @ObjectFieldType(ValueType.Date)
  public Date signedAt;

  @ObjectName("Подписавший")
  @ObjectDescription("Ссылка на подписавшего пользователя")
  @ObjectFieldType(ValueType.Bo)
  @PersonRef
  public BoiRef personRef;

  @ObjectName("Тип подписи")
  @ObjectDescription("Определяет тип подписи (ЭЦП или СМС)")
  @ObjectFieldType(ValueType.EnumRef)
  public MybpmSignatureType type;

  @ObjectName("Полное имя")
  @ObjectDescription("Полное имя подписавшего субъекта")
  @ObjectFieldType(ValueType.Text)
  public String fullName;

  @ObjectName("Подписанные поля")
  @ObjectDescription("Подписанные поля")
  @ObjectFieldType(ValueType.Object)
  public List<SignedField> signedFields = new ArrayList<>();

  @ObjectName("Номер телефона")
  @ObjectDescription("Номер телефона, на которого был отправлен код подтверждения. Значение проставляется только если тип подписи - СМС")
  @ObjectFieldType(ValueType.Text)
  public String phoneNumber;

  @ObjectName("Серийный номер сертификата")
  @ObjectDescription("Серийный номер сертификата. Значение проставляется только если тип подписи - ЭЦП")
  @ObjectFieldType(ValueType.Text)
  public String serialNumber;

  @ObjectName("ИИН")
  @ObjectDescription("ИИН подписавшего субъекта. Значение проставляется только если тип подписи - ЭЦП")
  @ObjectFieldType(ValueType.Text)
  public String iin;

}
