package kz.greetgo.script.model.expr.flow;

import java.util.HashMap;
import java.util.Map;
import kz.greetgo.kafka.model.KafkaModel;
import kz.greetgo.script.model.expr.Expr;
import lombok.ToString;

@ToString
@KafkaModel
public class ExprField extends Expr {

  public String exprId;

  public Map<String, FieldPointer> fieldPointers = new HashMap<>();

  public Map<String, FieldPointer> fieldPointers() {
    var x = fieldPointers;
    return x != null ? x : (fieldPointers = new HashMap<>());
  }

  public static ExprField of(String exprId) {
    ExprField exprField = new ExprField();
    exprField.exprId = exprId;
    return exprField;
  }

  public ExprField field(String fieldId) {
    double maxOrderIndex = fieldPointers().values().stream().mapToDouble(x -> x.orderIndex).max().orElse(0);

    float  newOrderIndex = (float) maxOrderIndex + 1;
    String newId         = ("efp_" + newOrderIndex).replaceAll("\\.", "_");

    FieldPointer fieldPointer = new FieldPointer();
    fieldPointer.fieldId    = fieldId;
    fieldPointer.orderIndex = newOrderIndex;
    fieldPointers().put(newId, fieldPointer);

    return this;
  }
}
