package kz.greetgo.script.model.expr.flow;

import java.util.HashMap;
import java.util.Map;
import kz.greetgo.kafka.model.KafkaModel;
import kz.greetgo.script.model.expr.Expr;
import kz.greetgo.script.model.expr.flow.func.FuncArg;
import lombok.ToString;

@ToString
@KafkaModel
public class ExprFunc extends Expr {
  public String groupId;
  public String funcId;

  public Map<String, FuncArg> args = new HashMap<>();

  public static ExprFunc of(String groupId, String funcId, Map<String, FuncArg> args) {
    ExprFunc ret = new ExprFunc();
    ret.groupId = groupId;
    ret.funcId  = funcId;
    ret.args    = args;
    return ret;
  }

}
