package kz.greetgo.script.model.expr.flow;

import java.util.Optional;
import kz.greetgo.script.ann.enums.EnumDescription;
import kz.greetgo.script.ann.enums.EnumName;
import lombok.SneakyThrows;

@EnumName("Тип метаданных поля")
@EnumDescription("Тип метаданных поля")
public enum FieldMetaType {

  @EnumName("Видимость")
  @EnumDescription("Видимость поля юзеру")
  Shown,

  @EnumName("Только для чтения")
  @EnumDescription("Только для чтения")
  Readonly,

  @EnumName("Обязателен для заполнения")
  @EnumDescription("Обязателен для заполнения")
  Required,
  ;

  public static Optional<FieldMetaType> valueOfOpt(String name) {
    if (name == null) {
      return Optional.empty();
    }
    try {
      return Optional.of(valueOf(name));
    } catch (IllegalArgumentException e) {
      return Optional.empty();
    }
  }

  @SneakyThrows
  public String displayStr() {
    return getClass().getField(name()).getAnnotation(EnumName.class).value();
  }
}
