package kz.greetgo.script.model.expr.flow.act;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ActIdUtil {
  public static String strValue(Map<String, String> data) {
    List<String> list = new ArrayList<>();

    data.entrySet()
        .stream()
        .sorted(Map.Entry.comparingByKey())
        .forEachOrdered(e -> {
          list.add(e.getKey());
          list.add(e.getValue());
        });

    return String.join("-", list);
  }

  public static Map<String, String> parse(String strValue) {
    String[] split = strValue.split("-");

    int N = split.length / 2;

    Map<String, String> ret = new HashMap<>();

    for (int i = 0; i < N; i++) {
      ret.put(split[2 * i + 0], split[2 * i + 1]);
    }

    return ret;
  }

  public static void checkOnCorrectChars(String id, String placeId) {
    if (id == null) {
      return;
    }
    String illegalChars = id.chars()
                            .filter(ActIdUtil::checkCharIsNotNormal)
                            .mapToObj(i -> "" + (char) i)
                            .collect(Collectors.joining());

    if (illegalChars.length() > 0) {
      throw new IncorrectChar(placeId, "Illegal chars in id." +
        " Id can contains only eng letters (a..zA..Z), digits (0..9), and underscore (_). Nothing more." +
        " But this id contains illegal chars: `" + illegalChars + "`");
    }
  }

  private static boolean checkCharIsNotNormal(int iChar) {
    return !checkCharIsNormal((char) iChar);
  }

  private static boolean checkCharIsNormal(char c) {
    if ('A' <= c && c <= 'Z') {
      return true;
    }
    if ('a' <= c && c <= 'z') {
      return true;
    }
    if ('0' <= c && c <= '9') {
      return true;
    }
    if (c == '_' || c == '~' || c == '@') {
      return true;
    }
    return false;
  }
}
