package kz.greetgo.script.model.expr.flow.act;

import java.util.HashMap;
import java.util.Map;

import static java.util.Objects.requireNonNull;
import static java.util.stream.Collectors.joining;
import static kz.greetgo.script.model.expr.flow.act.ActId.BASE_TYPE;
import static kz.greetgo.script.model.expr.flow.act.ActId.FIELD_CODE;
import static kz.greetgo.script.model.expr.flow.act.ActId.checkParamNames;
import static kz.greetgo.script.model.expr.flow.act.ActIdUtil.checkOnCorrectChars;

public class ActLocalId {

  public final Map<String, String> data;

  private ActLocalId(Map<String, String> data) {
    this.data = Map.copyOf(data);
  }

  public static ActLocalId fix(String baseType, String fieldCode, Map<String, String> params) {
    requireNonNull(baseType, "3Wy2qA2ui8 :: baseType");
    checkOnCorrectChars(baseType, "4z75EvINnn :: baseType");
    requireNonNull(fieldCode, "74B2Z9Vz9O :: fieldCode");
    checkOnCorrectChars(fieldCode, "97zc0YLSf0 :: fieldCode");
    checkParamNames("Wp42E2QtH9", params);

    Map<String, String> data = new HashMap<>(params);
    data.put(BASE_TYPE, baseType);
    data.put(FIELD_CODE, fieldCode);

    return new ActLocalId(data);
  }

  public static ActLocalId dyn(String fieldCode, Map<String, String> params) {
    requireNonNull(fieldCode, "74B2Z9Vz9O :: fieldCode");
    checkOnCorrectChars(fieldCode, "97zc0YLSf0 :: fieldCode");
    checkParamNames("jw94Z7V7A9", params);

    Map<String, String> data = new HashMap<>(params);
    data.put(FIELD_CODE, fieldCode);

    return new ActLocalId(data);
  }

  public static ActLocalId dyn(String fieldCode) {
    return dyn(fieldCode, Map.of());
  }

  public static ActLocalId fix(String baseType, String fieldCode) {
    return fix(baseType, fieldCode, Map.of());
  }

  public String strValue() {
    return ActIdUtil.strValue(data);
  }

  public static ActLocalId parse(String strValue) {
    return new ActLocalId(ActIdUtil.parse(strValue));
  }

  public String baseType() {
    return data.get(BASE_TYPE);
  }

  public String fieldCode() {
    return data.get(FIELD_CODE);
  }

  public String get(String paramName) {
    return data.get(paramName);
  }

  public static ActLocalId from(ActId actId) {
    Map<String, String> data = actId.restParams();
    if (actId.kind() != ActIdKind.DYN) {
      data.put(BASE_TYPE, requireNonNull(actId.data.get(BASE_TYPE), "t64sJK0q7u :: BASE_TYPE"));
    }
    data.put(FIELD_CODE, requireNonNull(actId.data.get(FIELD_CODE), "FCbfMy1eNv :: FIELD_CODE"));
    return new ActLocalId(data);
  }

  @Override
  public String toString() {
    return getClass().getSimpleName()
      + '{'
      + data.entrySet()
            .stream()
            .sorted(Map.Entry.comparingByKey())
            .map(e -> e.getKey() + '=' + e.getValue())
            .collect(joining(", "))
      + '}';
  }
}
