package kz.greetgo.script.model.expr.flow.boi_filter;

import kz.greetgo.kafka.model.KafkaModel;
import kz.greetgo.script.model.expr.flow.boi_filter.enums.LogicType;

@KafkaModel
public class ScrBoiFilterLogic extends ScrBoiFilter {

  /**
   * Ссылка на {@link ScrBoiFilter}
   * <p>
   * Фильтр стоящий слева от операции
   */
  public ScrBoiFilter leftFilter;

  /**
   * Логическая операция
   */
  public LogicType logicType;

  /**
   * Ссылка на {@link ScrBoiFilter}
   * <p>
   * Фильтр стоящий справа от операции
   */
  public ScrBoiFilter rightFilter;

  public static ScrBoiFilterLogic of(ScrBoiFilter leftFilter, LogicType logicType, ScrBoiFilter rightFilter) {
    ScrBoiFilterLogic ret = new ScrBoiFilterLogic();
    ret.leftFilter  = leftFilter;
    ret.logicType   = logicType;
    ret.rightFilter = rightFilter;
    return ret;
  }
}
