package kz.greetgo.script.model.expr.flow.value.fields;

import java.util.ArrayList;
import java.util.List;
import kz.greetgo.script.model.expr.Expr;
import kz.greetgo.script.model.expr.flow.value.ConstFormFieldType;
import lombok.ToString;

@ToString
public class ConstFormComponent {

  public String fieldCode;

  /**
   * Определяет отображать данный компонент на форме диалога или нет.
   * <p>
   * Содержит в себе список dot-путей указывающих на поля структуры {@link Expr} (или её наследников).
   * <p>
   * Компонент отображается, если заполнены все указанные поля. Если хотя бы одно поле пустое, то компонент не отображается.
   * <p>
   * Если не указать ни одного значения (пустой массив), то компонент будет отображаться всегда
   */
  public List<String> showIfAllDefined_dataDotPaths = new ArrayList<>();

  /**
   * Если установлено в true, то при выборе значения в этом компоненте и после сохранения нового значения на сервере, диалоговое окно закрывается
   */
  public boolean closeOnEnter;

  /**
   * Показывает какое-количество уровней отображать в плашке
   */
  public int displayCount;

  /**
   * Показывает какой уровень, соответствует данному компоненту формы
   */
  public int displayNumber;

  public ConstFormFieldType getType() {
    String simpleName = getClass().getSimpleName();
    String prefix     = ConstFormComponent.class.getSimpleName();
    if (!simpleName.startsWith(prefix)) {
      throw new RuntimeException("62kmtPR1OA :: Не правильное название класса - он должен называть начиная с "
                                   + prefix
                                   + " и заканчиваться значением из enum-а: "
                                   + ConstFormFieldType.class.getSimpleName());
    }
    return ConstFormFieldType.valueOf(simpleName.substring(prefix.length()));
  }

}
