package kz.greetgo.script.model.expr.flow.value.fields;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kz.greetgo.script.model.expr.Expr;
import kz.greetgo.script.model.expr.flow.value.ConstFieldRecord;
import kz.greetgo.script.model.expr.flow.value.LoadConstFieldListRequest;
import lombok.ToString;

@ToString(callSuper = true)
public class ConstFormComponentListFilterPaging extends ConstFormComponent {
  /**
   * Список dot-путей указывающих на поля структуры {@link Expr} (или её наследников).
   * Значения этих полей помещаются в поле {@link LoadConstFieldListRequest#inputDataValues} в значение мапы.
   * Ключом мапы являются сами эти dot-пути.
   */
  public List<String> inputDataDotPaths = new ArrayList<>();

  /**
   * Список dot-путей значений, которые вынимаются из структуры {@link Expr} (или её наследников).
   * <p>
   * Из этих значений собирается идентификатор записи посредством конкатенации через решётку '#'.
   * <p>
   * Этот идентификатор записывается в поле {@link ConstFieldRecord#id}.
   */
  public List<String> recordIdDotPaths = new ArrayList<>();

  /**
   * Расчерчивает какие данные будут меняться при выборе записи пользователем.
   * <p>
   * Ключом мапы является dot-путь обновляемого поля в {@link Expr} (или её наследников).
   * <p>
   * Значение мапы является индекс массива значений.
   * <p>
   * Массив значений получается путём разрезания идентификатора записи {@link ConstFieldRecord#id} по символам `решётка` (#).
   * <p>
   * Идентификатор записи {@link ConstFieldRecord#id} формируется из данных обозначаемых полем {@link #recordIdDotPaths}
   */
  public Map<String, Integer> updateDotPathMap = new HashMap<>();

  /**
   * У наследников класса {@link Expr} есть данные, и здесь указаны dot-пути тех полей, которые будут очищены при выборе.
   * <p>
   * Это может понадобиться для избежания несогласованных значений идентификаторов.
   */
  public List<String> unsetDotPaths = new ArrayList<>();

  /**
   * Надпись на фоне поля фильтра
   */
  public String filterPlaceHolder;

  /**
   * Максимальная высота списка. Пример значения: `350px`
   */
  public String listMaxHeight;

  public boolean updateExtType;
}
