package kz.greetgo.script.model.translate;

import java.util.HashMap;
import java.util.Map;

public class ScriptDiagnosticMessage {

  public String scriptId;

  public ScriptDiagnosticType  type;
  public ScriptDiagnosticPlace place;

  public String messageCode;

  public String message;
  public String sourceMessage;
  public String blockId;
  public String exprId;

  public Map<String, String> messageArgs = new HashMap<>();

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append(getClass().getSimpleName()).append("{\n");
    if (scriptId != null) {
      sb.append("  scriptId = ").append(scriptId).append("\n");
    }
    if (type != null) {
      sb.append("  type = ").append(type).append("\n");
    }
    if (place != null) {
      sb.append("  place = ").append(place).append("\n");
    }
    if (messageCode != null) {
      sb.append("  messageCode = ").append(messageCode).append("\n");
    }
    if (message != null) {
      sb.append("  message = ").append(message).append("\n");
    }
    if (sourceMessage != null) {
      sb.append("  sourceMessage = ").append(sourceMessage).append("\n");
    }
    if (blockId != null) {
      sb.append("  blockId = ").append(blockId).append("\n");
    }
    if (exprId != null) {
      sb.append("  exprId = ").append(exprId).append("\n");
    }
    if (messageArgs != null && messageArgs.size() > 0) {
      sb.append("  messageArgs = ").append(messageArgs).append("\n");
    }
    sb.append("}");
    return sb.toString();
  }
}
