package kz.greetgo.script.model;

import java.util.HashMap;
import java.util.Map;
import kz.greetgo.kafka.model.KafkaModel;
import kz.greetgo.script.model.block.Block;
import kz.greetgo.script.model.expr.Expr;
import lombok.ToString;
import lombok.experimental.FieldNameConstants;

@ToString
@KafkaModel
@FieldNameConstants
public class ScriptDef {

  public Map<String, Block> blocks = new HashMap<>();

  public Map<String, Expr> expressions = new HashMap<>();

  public Map<String, Block> blocks() {
    var x = blocks;
    return x != null ? x : (blocks = new HashMap<>());
  }

  public Map<String, Expr> expressions() {
    var x = expressions;
    return x != null ? x : (expressions = new HashMap<>());
  }

  public void putExpr(String exprId, Expr expr) {
    var e = expressions();
    if (e.containsKey(exprId)) {
      throw new RuntimeException("40qe014xSn :: expression with such id already exists: exprId=`" + exprId + "`");
    }
    e.put(exprId, expr);
  }

  public void putBlock(String blockId, Block block) {
    var e = blocks();
    if (e.containsKey(blockId)) {
      throw new RuntimeException("9R3MLQ1atu :: block with such id already exists: blockId=`" + blockId + "`");
    }
    e.put(blockId, block);
  }

}
