package kz.greetgo.script.model.block.con1;

import kz.greetgo.script.model.block.enums.BlockExitType;

/**
 * Блок выхода из различных конструкций скрипта.
 * С помощью него можно выйти из цикла как целиком, так и из текущей итерации
 * с последующим началом следующей итерации. А также можно выйти из скрипта.
 * Выход из скрипта можно осуществить по конкретной стрелке.
 */
public class BlockExit extends BlockCon {

  /**
   * Тип выхода
   */
  public BlockExitType exitType;

  /**
   * Используется, если exitType === FROM_CIRCLE или FROM_CIRCLE_ITER
   * <p>
   * Указывает блок цикла, из которого нужно выйти
   */
  public String circleBlockId;

  /**
   * Используется, если exitType === FROM_METHOD_BY_ARROW
   * <p>
   * Указывает идентификатор стрелки процесса, по которой нужно выйти из скрипта
   */
  public String targetArrowId;

  public static BlockExit fromMethod() {
    BlockExit ret = new BlockExit();
    ret.exitType = BlockExitType.FROM_METHOD;
    return ret;
  }
}
