package kz.greetgo.script.model.context.controller.func;

import java.util.List;
import kz.greetgo.script.ann.func.FuncDescription;
import kz.greetgo.script.ann.func.FuncName;
import kz.greetgo.script.ann.func.FuncParamDescription;
import kz.greetgo.script.ann.func.FuncParamName;
import kz.greetgo.script.ann.func.FuncParamType;
import kz.greetgo.script.ann.func.FuncReturnDescription;
import kz.greetgo.script.ann.model.ValueType;
import kz.greetgo.script.model.context.model.BoiRef;
import kz.greetgo.script.model.context.model.signature.MybpmSignature;

@FuncName("Работа с подписями")
@FuncDescription("Работа с подписями")
public interface SignatureFuncController {

  @FuncName("Получить подписи")
  @FuncDescription("Получить подписи выбранной инстанции бизнес объекта")
  @FuncReturnDescription("Возвращает список подписей")
  List<MybpmSignature> readSignatures(

    @FuncParamName("Ссылка на БОИ")
    @FuncParamDescription("Ссылка на БОИ, подписи которой нужно прочитать")
    @FuncParamType(ValueType.Bo)
      BoiRef boiRef

  );

  @FuncName("Удалить подпись")
  @FuncDescription("Удаляет подпись в выбранной инстанции бизнес объекта")
  void removeSignature(

    @FuncParamName("Подпись")
    @FuncParamDescription("Подпись, которую надо удалить")
    @FuncParamType(ValueType.Object)
      MybpmSignature signature

  );

}
