package kz.greetgo.script.model.context.diagnostic;

import java.util.HashMap;
import java.util.Map;
import kz.greetgo.script.model.context.MessageFormatter;
import kz.greetgo.script.model.translate.ScriptDiagnosticPlace;
import kz.greetgo.script.model.translate.ScriptDiagnosticType;
import lombok.experimental.FieldNameConstants;

@FieldNameConstants
public class ScriptDiagnosticMessageDto {

  public String scriptId;

  public ScriptDiagnosticType  type;
  public ScriptDiagnosticPlace place;

  public String              messageCode;
  public String              message;
  public Map<String, String> messageArgs = new HashMap<>();
  public String              blockId;
  public String              exprId;

  /**
   * Имя файла и номер строки в файле, где произошла ошибка
   */
  public String sourceMessage;

  public String placeDisplay() {
    if (place == null) {
      return "Unknown";
    }
    switch (place) {

      case EXPR:
        return "Expr:exprId=" + exprId + ",scriptId=" + scriptId;

      case BLOCK:
        return "Block:blockId=" + blockId + ",scriptId=" + scriptId;

      case SCRIPT:
        return "Script:scriptId=" + scriptId;

      default:
        return place.toString();
    }
  }

  @Override
  public String toString() {
    return "DiaMessage{" + detailedMessage() + "}";
  }

  public String detailedMessage() {
    if (sourceMessage != null) {
      return sourceMessage;
    }
    return type + ": " + messageCode + ", " + messageArgs + ", " + placeDisplay() + ": " + message;
  }

  public String message() {
    return MessageFormatter.format(message, messageArgs);
  }

  public void setPlaceId(ScriptDiagnosticPlace place, String placeId) {
    this.place = place;

    switch (place) {
      case EXPR:
        exprId = placeId;
        return;

      case BLOCK:
        blockId = placeId;
        return;

      default:
        return;
    }
  }

  public String address() {
    switch (place) {

      case SCRIPT:
        return "SCRIPT: scriptId=" + scriptId;

      case BLOCK:
        return "BLOCK: scriptId=" + scriptId + ", blockId=" + blockId;

      case EXPR:
        return "EXPR: scriptId=" + scriptId + ", exprId=" + exprId;

      default:
        return "?";
    }
  }
}
