package kz.greetgo.script.model.context.model;

import java.util.Objects;
import kz.greetgo.mybpm.model_web.web_dynamic_forms.BoInstanceId;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.ToString;

@Getter
@ToString
@NoArgsConstructor
@AllArgsConstructor
public class BoiRef {
  public String boId;
  public String boiId;

  public static BoiRef of(String boId, String boiId) {
    return new BoiRef(boId, boiId);
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof BoiRef)) {
      return false;
    }
    final BoiRef boiRef = (BoiRef) o;

    BoInstanceId boInstanceId1 = BoInstanceId.parseOrNull(boiId);
    BoInstanceId boInstanceId2 = BoInstanceId.parseOrNull(boiRef.boiId);

    if (boInstanceId1 != null && boInstanceId2 != null) {

      return Objects.equals(boInstanceId1, boInstanceId2);

    }

    if (boInstanceId1 != null) {

      return Objects.equals(boInstanceId1.boId, boiRef.getBoId()) && Objects.equals(boInstanceId1.boiId, boiRef.getBoiId());

    }

    if (boInstanceId2 != null) {

      return Objects.equals(boId, boInstanceId2.boId) && Objects.equals(boiId, boInstanceId2.boiId);

    }

    return Objects.equals(getBoId(), boiRef.getBoId()) && Objects.equals(getBoiId(), boiRef.getBoiId());
  }

  @Override
  public int hashCode() {

    BoInstanceId boInstanceId = BoInstanceId.parseOrNull(boiId);

    if (boInstanceId == null) {

      return Objects.hash(boId, boiId);

    }

    return Objects.hash(boInstanceId.boId, boInstanceId.boiId);

  }

}
