package kz.greetgo.script.model.context.model;

import java.util.Objects;
import kz.greetgo.mongo_kafka.gen.annotation.StrGenerator;
import kz.greetgo.mongo_kafka.gen.annotation.StrParser;

public class FieldOption {

  public final String fieldId;
  public final String optionId;

  private FieldOption(String fieldId, String optionId) {
    this.fieldId  = fieldId;
    this.optionId = optionId;
  }

  public static FieldOption of(String fieldId, String optionId) {
    Objects.requireNonNull(fieldId);
    Objects.requireNonNull(optionId);
    return new FieldOption(fieldId, optionId);
  }

  @StrGenerator
  public String toStr() {
    return "FIELD_OPTION-" + fieldId + "-" + optionId;
  }

  @StrParser
  public static FieldOption parse(String str) {
    if (str == null || str.isBlank()) {
      return null;
    }
    String[] groups = str.split("-");
    if (groups.length != 3 || !"FIELD_OPTION".equals(groups[0])) {
      return null;
    }

    return of(groups[1], groups[2]);
  }

}
