package kz.greetgo.script.model.context.model;

import java.util.Objects;
import lombok.RequiredArgsConstructor;
import lombok.ToString;

@ToString
@RequiredArgsConstructor
public class SingleSelectRef {
  public final String boId;
  public final String fieldId;
  public final String optionId;

  public static SingleSelectRef of(String boId, String fieldId, String optionId) {
    return new SingleSelectRef(boId, fieldId, optionId);
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof SingleSelectRef)) {
      return false;
    }
    final SingleSelectRef that = (SingleSelectRef) o;
    return Objects.equals(optionId, that.optionId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(optionId);
  }
}
