package kz.greetgo.script.model.expr.flow;

import java.util.HashMap;
import java.util.Map;
import kz.greetgo.kafka.model.KafkaModel;
import kz.greetgo.script.model.expr.Expr;
import lombok.ToString;

@ToString
@KafkaModel
public class ExprCall extends Expr {

  public String funcName;

  public boolean useArgNames;

  public Map<String, CallArg> args = new HashMap<>();

  public static ExprCall of() {
    return new ExprCall();
  }

  public ExprCall arg(String argId, CallArg callArg) {
    args.put(argId, callArg);
    return this;
  }
}
