package kz.greetgo.script.model.expr.flow;

import java.util.HashMap;
import java.util.Map;
import kz.greetgo.kafka.model.KafkaModel;
import kz.greetgo.script.model.expr.Expr;
import kz.greetgo.script.model.expr.enums.OpType;
import lombok.ToString;

@ToString
@KafkaModel
public class ExprOp extends Expr {

  public OpType opType;

  public String leftExprId;

  public String rightExprId;

  public Map<String, MoreOp> more = new HashMap<>();

  public static ExprOp of(String leftExprId, OpType opType, String rightExprId) {
    ExprOp e = new ExprOp();
    e.opType      = opType;
    e.leftExprId  = leftExprId;
    e.rightExprId = rightExprId;
    return e;
  }

  public ExprOp more(OpType opType, String exprId) {

    MoreOp moreOp = new MoreOp();
    moreOp.order  = more.values().stream().mapToInt(x -> x.order).max().orElse(0) + 10;
    moreOp.opType = opType;
    moreOp.exprId = exprId;

    more.put("more" + (more.size() + 1), moreOp);

    return this;
  }
}
