package kz.greetgo.script.model.expr.flow.act;

import java.util.Map;
import java.util.stream.Collectors;
import lombok.AccessLevel;
import lombok.EqualsAndHashCode;
import lombok.RequiredArgsConstructor;

import static java.util.Objects.requireNonNull;
import static kz.greetgo.script.model.expr.flow.act.ActIdUtil.checkOnCorrectChars;

@EqualsAndHashCode
@RequiredArgsConstructor(access = AccessLevel.PRIVATE)
public class ActSourceId {

  public final Map<String, String> data;

  public static ActSourceId fromData(Map<String, String> data) {
    return of(data.get(ActId.PLUGIN_ID), data.get(ActId.ACT_SOURCE_ID));
  }

  public static ActSourceId ofPlugin(String pluginId, String localActSourceId) {

    requireNonNull(pluginId, "9E68rz1mTJ :: pluginId");
    checkOnCorrectChars(pluginId, "C93zK2pW25 :: pluginId");

    requireNonNull(localActSourceId, "EHW70IoZ01 :: localActSourceId");
    checkOnCorrectChars(localActSourceId, "61HuP3iSq4 :: localActSourceId");

    return new ActSourceId(Map.of(ActId.PLUGIN_ID, pluginId, ActId.ACT_SOURCE_ID, localActSourceId));
  }

  public static ActSourceId ofCore(String localActSourceId) {
    requireNonNull(localActSourceId, "V7B11kYkKK :: localActSourceId");
    checkOnCorrectChars(localActSourceId, "gY5hyVfBHS :: localActSourceId");
    return new ActSourceId(Map.of(ActId.ACT_SOURCE_ID, localActSourceId));
  }

  public static ActSourceId of(String sourcePluginId, String localSourceId) {
    return sourcePluginId == null || sourcePluginId.isEmpty() ? ofCore(localSourceId) : ofPlugin(sourcePluginId, localSourceId);
  }

  public String pluginId() {
    return data.get(ActId.PLUGIN_ID);
  }

  public String localSourceId() {
    return data.get(ActId.ACT_SOURCE_ID);
  }

  @Override
  public String toString() {
    return getClass().getSimpleName()
      + "{"
      + data.entrySet()
            .stream()
            .sorted(Map.Entry.comparingByKey())
            .map(e -> e.getKey() + "=`" + e.getValue() + "`")
            .collect(Collectors.joining(","))
      + "}";
  }
}
