package kz.greetgo.script.model.update;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import kz.greetgo.script.model.translate.ValueExtType;
import lombok.experimental.FieldNameConstants;

/**
 * Мета-состояние скрипта, которое вычисляется на сервере.
 * <p>
 * Мета-состояние определяет типы выражений и типы переменных, объявленных в блоках.
 * <p>
 * Также некоторые наименования плашек
 */
@FieldNameConstants
public class ScriptMetaState {

  /**
   * Для каждого выражения предоставляет его тип
   * <p>
   * Ключ колоды - идентификатор выражения
   * <p>
   * Значение колоды - тип выражения
   */
  public Map<String, ValueExtType> exprValueTypeMap = new HashMap<>();

  /**
   * Отображаемые имена актов (ExprAct)
   * <p>
   * Ключ колоды - идентификатор выражения акта
   * <p>
   * Значение колоды - отображаемое имя акта
   */
  public Map<String, ActDisplayNames> exprActDisplayNames = new HashMap<>();

  /**
   * Отображаемые имена выражений-значений (ExprValue)
   * <p>
   * Ключ колоды - идентификатор выражения
   * <p>
   * Значение колоды - отображаемое имя выражения
   */
  public Map<String, String> exprValueDisplays = new HashMap<>();

  /**
   * Состояния блоков assign (присваивания)
   * <p>
   * Ключ колоды - идентификатор блока
   * <p>
   * Значение колоды - состояние блока
   */
  public Map<String, BlockAssignState> blockAssignStates = new HashMap<>();

  public static ScriptMetaState delta(ScriptMetaState stateBefore, ScriptMetaState stateAfter) {
    ScriptMetaState delta = new ScriptMetaState();

    delta.exprValueTypeMap    = deltaMap(stateAfter.exprValueTypeMap, stateBefore.exprValueTypeMap);
    delta.exprActDisplayNames = deltaMap(stateAfter.exprActDisplayNames, stateBefore.exprActDisplayNames);
    delta.exprValueDisplays   = deltaMap(stateAfter.exprValueDisplays, stateBefore.exprValueDisplays);
    delta.blockAssignStates   = deltaMap(stateAfter.blockAssignStates, stateBefore.blockAssignStates);

    return delta;
  }

  private static <T> Map<String, T> deltaMap(Map<String, T> after, Map<String, T> before) {

    Map<String, T> delta = new HashMap<>();

    for (final Map.Entry<String, T> e : after.entrySet()) {
      String key   = e.getKey();
      T      value = e.getValue();

      if (!(Objects.equals(value, before.get(key)))) {
        delta.put(key, value);
      }
    }

    for (final String key : before.keySet()) {
      if (!after.containsKey(key)) {
        delta.put(key, null);
      }
    }

    return delta;
  }
}
