package kz.greetgo.script.model.util;

import java.math.BigDecimal;
import java.util.Date;
import kz.greetgo.script.ann.model.ValueType;
import kz.greetgo.script.model.context.model.BoiFieldRef;
import kz.greetgo.script.model.context.model.GeoPoint;
import kz.greetgo.script.model.context.model.Period;
import kz.greetgo.script.model.context.model.SingleSelectRef;
import kz.greetgo.script.model.context.model.signature.MybpmFile;
import kz.greetgo.script.model.translate.ValueExtType;

public class ValueExtTypeUtil {

  public static ValueExtType fromSimpleToValueExtType(Class<?> aClass) {

    if (String.class.equals(aClass)) {
      return ValueExtType.text();
    }
    if (BigDecimal.class.equals(aClass)) {
      return ValueExtType.number();
    }
    if (Boolean.class.equals(aClass) || boolean.class.equals(aClass)) {
      return ValueExtType.bool();
    }
    if (Date.class.equals(aClass)) {
      return ValueExtType.date();
    }
    if (Period.class.equals(aClass)) {
      return ValueExtType.period();
    }
    if (GeoPoint.class.equals(aClass)) {
      return ValueExtType.geoPoint();
    }
    if (SingleSelectRef.class.equals(aClass)) {
      return ValueExtType.singleSelect(null, null);
    }
    if (BoiFieldRef.class.equals(aClass)) {
      return ValueExtType.boiFieldRef(null, null);
    }
    if (MybpmFile.class.equals(aClass)) {
      return ValueExtType.mybpmFile();
    }
    if (aClass.isEnum()) {
      ValueExtType valueExtType = ValueExtType.single(ValueType.EnumRef);
      valueExtType.baseType       = aClass.getSimpleName();
      valueExtType.enumNativeName = aClass.getSimpleName();
      return valueExtType;
    }

    return null;

  }

}
