/*
 * Decompiled with CFR 0.152.
 */
package kz.greetgo.script.model.context.act;

import java.util.Optional;
import kz.greetgo.mybpm_util_light.filter.StrFilter;
import kz.greetgo.mybpm_util_light.filter.StrFilterResult;
import kz.greetgo.script.model.expr.flow.act.ActId;
import kz.greetgo.script.model.expr.flow.act.ActLocalId;
import kz.greetgo.script.model.expr.flow.act.ActRecord;
import kz.greetgo.script.model.expr.flow.act.ActSourceId;

public class ActDisplay {
    public final ActLocalId localId;
    public final String displayStr;

    public Optional<ActRecord> filter(ActSourceId actSourceId, StrFilter strFilter, String filter) {
        StrFilterResult filterResult = strFilter.filter(filter, this.displayStr);
        if (!filterResult.found) {
            return Optional.empty();
        }
        ActId actId = ActId.dynamic(actSourceId, this.localId);
        ActRecord actRecord = new ActRecord();
        actRecord.id = actId.strValue();
        actRecord.displayStr = filterResult.markedFindStr;
        return Optional.of(actRecord);
    }

    ActDisplay(ActLocalId localId, String displayStr) {
        this.localId = localId;
        this.displayStr = displayStr;
    }

    public static ActDisplayBuilder builder() {
        return new ActDisplayBuilder();
    }

    public String toString() {
        return "ActDisplay(localId=" + this.localId + ", displayStr=" + this.displayStr + ")";
    }

    public static class ActDisplayBuilder {
        private ActLocalId localId;
        private String displayStr;

        ActDisplayBuilder() {
        }

        public ActDisplayBuilder localId(ActLocalId localId) {
            this.localId = localId;
            return this;
        }

        public ActDisplayBuilder displayStr(String displayStr) {
            this.displayStr = displayStr;
            return this;
        }

        public ActDisplay build() {
            return new ActDisplay(this.localId, this.displayStr);
        }

        public String toString() {
            return "ActDisplay.ActDisplayBuilder(localId=" + this.localId + ", displayStr=" + this.displayStr + ")";
        }
    }
}

