/*
 * Decompiled with CFR 0.152.
 */
package kz.greetgo.script.model.context.diagnostic;

import java.util.HashMap;
import java.util.Map;
import kz.greetgo.script.model.context.MessageFormatter;
import kz.greetgo.script.model.translate.ScriptDiagnosticPlace;
import kz.greetgo.script.model.translate.ScriptDiagnosticType;

public class ScriptDiagnosticMessageDto {
    public String scriptId;
    public ScriptDiagnosticType type;
    public ScriptDiagnosticPlace place;
    public String messageCode;
    public String message;
    public Map<String, String> messageArgs = new HashMap<String, String>();
    public String blockId;
    public String exprId;
    public String sourceMessage;

    public String placeDisplay() {
        if (this.place == null) {
            return "Unknown";
        }
        switch (this.place) {
            case EXPR: {
                return "Expr:exprId=" + this.exprId + ",scriptId=" + this.scriptId;
            }
            case BLOCK: {
                return "Block:blockId=" + this.blockId + ",scriptId=" + this.scriptId;
            }
            case SCRIPT: {
                return "Script:scriptId=" + this.scriptId;
            }
        }
        return this.place.toString();
    }

    public String toString() {
        return "DiaMessage{" + this.detailedMessage() + "}";
    }

    public String detailedMessage() {
        if (this.sourceMessage != null) {
            return this.sourceMessage;
        }
        return this.type + ": " + this.messageCode + ", " + this.messageArgs + ", " + this.placeDisplay() + ": " + this.message;
    }

    public String message() {
        return MessageFormatter.format(this.message, this.messageArgs);
    }

    public void setPlaceId(ScriptDiagnosticPlace place, String placeId) {
        this.place = place;
        switch (place) {
            case EXPR: {
                this.exprId = placeId;
                return;
            }
            case BLOCK: {
                this.blockId = placeId;
                return;
            }
        }
    }

    public String address() {
        switch (this.place) {
            case SCRIPT: {
                return "SCRIPT: scriptId=" + this.scriptId;
            }
            case BLOCK: {
                return "BLOCK: scriptId=" + this.scriptId + ", blockId=" + this.blockId;
            }
            case EXPR: {
                return "EXPR: scriptId=" + this.scriptId + ", exprId=" + this.exprId;
            }
        }
        return "?";
    }

    public static final class Fields {
        public static final String scriptId = "scriptId";
        public static final String type = "type";
        public static final String place = "place";
        public static final String messageCode = "messageCode";
        public static final String message = "message";
        public static final String messageArgs = "messageArgs";
        public static final String blockId = "blockId";
        public static final String exprId = "exprId";
        public static final String sourceMessage = "sourceMessage";
    }
}

