/*
 * Decompiled with CFR 0.152.
 */
package kz.greetgo.script.model.definitions.func.extractor;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import kz.greetgo.script.ann.func.FuncDescription;
import kz.greetgo.script.ann.func.FuncDisabled;
import kz.greetgo.script.ann.func.FuncName;
import kz.greetgo.script.ann.func.FuncParamDescription;
import kz.greetgo.script.ann.func.FuncParamName;
import kz.greetgo.script.ann.func.FuncParamNewLine;
import kz.greetgo.script.ann.func.FuncParamNullable;
import kz.greetgo.script.ann.func.FuncParamType;
import kz.greetgo.script.ann.func.FuncReturnDescription;
import kz.greetgo.script.ann.func.FuncReturnType;
import kz.greetgo.script.ann.model.ValueType;
import kz.greetgo.script.ann.object.ObjectNativeName;
import kz.greetgo.script.model.context.ScriptFuncContext;
import kz.greetgo.script.model.context.ScriptObjectContext;
import kz.greetgo.script.model.context.model.BoiRef;
import kz.greetgo.script.model.definitions.func.FuncArgDefinition;
import kz.greetgo.script.model.definitions.func.FuncDefinition;
import kz.greetgo.script.model.definitions.func.FuncGroupDefinition;
import kz.greetgo.script.model.definitions.func.FuncGroupsDefinition;
import kz.greetgo.script.model.definitions.func.FuncRetDefinition;
import kz.greetgo.script.model.translate.ValueExtType;
import kz.greetgo.script.model.util.ValueExtTypeUtil;
import org.jetbrains.annotations.Nullable;

public class FuncGroupsDefinitionExtractor {
    private static final Map<Class<? extends ScriptObjectContext>, FuncGroupsDefinition> cached = new ConcurrentHashMap<Class<? extends ScriptObjectContext>, FuncGroupsDefinition>();

    public static void init(Class<? extends ScriptObjectContext> scriptObjectContextClass) {
        FuncGroupsDefinitionExtractor.loadFuncGroupsDefinition(scriptObjectContextClass);
    }

    public static FuncGroupsDefinition loadFuncGroupsDefinitionFirst() {
        return cached.entrySet().stream().findFirst().map(Map.Entry::getValue).orElse(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FuncGroupsDefinition loadFuncGroupsDefinition(Class<? extends ScriptObjectContext> scriptObjectContextClass) {
        FuncGroupsDefinition fromCache = cached.get(scriptObjectContextClass);
        if (fromCache != null) {
            return fromCache;
        }
        Map<Class<? extends ScriptObjectContext>, FuncGroupsDefinition> map = cached;
        synchronized (map) {
            FuncGroupsDefinition fromCache2 = cached.get(scriptObjectContextClass);
            if (fromCache2 != null) {
                return fromCache2;
            }
            FuncGroupsDefinition load = FuncGroupsDefinitionExtractor.load();
            cached.put(scriptObjectContextClass, load);
            return load;
        }
    }

    private static FuncGroupsDefinition load() {
        FuncGroupsDefinition funcGroupsDefinition = new FuncGroupsDefinition();
        funcGroupsDefinition.groups = Arrays.stream(ScriptFuncContext.class.getDeclaredMethods()).map(FuncGroupsDefinitionExtractor::extract).collect(Collectors.toMap(k -> k.nativeName, v -> v));
        return funcGroupsDefinition;
    }

    private static FuncGroupDefinition extract(Method method) {
        FuncGroupDefinition funcGroupDefinition = new FuncGroupDefinition();
        Class<?> funcController = method.getReturnType();
        FuncName funcName = funcController.getAnnotation(FuncName.class);
        if (funcName == null) {
            throw new RuntimeException("E8IXb15GIa :: \u041d\u0435\u0442 \u0430\u043d\u043d\u043e\u0442\u0430\u0446\u0438\u0438 FuncName \u0443 \u043a\u043b\u0430\u0441\u0441\u0430 " + funcController.getSimpleName());
        }
        FuncDescription funcDescription = funcController.getAnnotation(FuncDescription.class);
        if (funcDescription == null) {
            throw new RuntimeException("5d3eMe4t0V :: \u041d\u0435\u0442 \u0430\u043d\u043d\u043e\u0442\u0430\u0446\u0438\u0438 FuncDescription \u0443 \u043a\u043b\u0430\u0441\u0441\u0430 " + funcController.getSimpleName());
        }
        FuncDisabled funcDisabled = funcController.getAnnotation(FuncDisabled.class);
        String simpleName = funcController.getSimpleName();
        funcGroupDefinition.name = funcName.value();
        funcGroupDefinition.description = funcDescription.value();
        funcGroupDefinition.nativeName = method.getName();
        funcGroupDefinition.disabled = funcDisabled != null;
        funcGroupDefinition.functions = Arrays.stream(funcController.getDeclaredMethods()).map(x -> FuncGroupsDefinitionExtractor.toFuncDefinition(x, simpleName)).collect(Collectors.toMap(k -> k.nativeName, v -> v));
        return funcGroupDefinition;
    }

    private static FuncDefinition toFuncDefinition(Method method, String simpleName) {
        String path = simpleName + "." + method.getName();
        FuncDefinition funcDefinition = new FuncDefinition();
        FuncName funcName = method.getAnnotation(FuncName.class);
        if (funcName == null) {
            throw new RuntimeException("VSxCD4nMtd :: \u041d\u0435\u0442 \u0430\u043d\u043d\u043e\u0442\u0430\u0446\u0438\u0438 FuncName \u0443 \u043c\u0435\u0442\u043e\u0434\u0430 " + path);
        }
        FuncDescription funcDescription = method.getAnnotation(FuncDescription.class);
        if (funcDescription == null) {
            throw new RuntimeException("K2mrzDfn1R :: \u041d\u0435\u0442 \u0430\u043d\u043d\u043e\u0442\u0430\u0446\u0438\u0438 FuncDescription \u0443 \u043c\u0435\u0442\u043e\u0434\u0430 " + path);
        }
        funcDefinition.name = funcName.value();
        funcDefinition.description = funcDescription.value();
        funcDefinition.nativeName = method.getName();
        if (method.getGenericReturnType() != Void.TYPE) {
            FuncReturnDescription funcReturnDescription = method.getAnnotation(FuncReturnDescription.class);
            if (funcReturnDescription == null) {
                throw new RuntimeException("MOlWeUE4n8 :: \u041d\u0435\u0442 \u0430\u043d\u043d\u043e\u0442\u0430\u0446\u0438\u0438 FuncReturnDescription \u0443 \u0432\u043e\u0437\u0432\u0440\u0430\u0449\u0430\u0435\u043c\u043e\u0433\u043e \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u0430, \u043c\u0435\u0442\u043e\u0434\u0430 " + path);
            }
            String returnTypePath = path + " return type ";
            FuncRetDefinition returnDefinition = new FuncRetDefinition();
            returnDefinition.description = funcReturnDescription.value();
            returnDefinition.type = FuncGroupsDefinitionExtractor.toValueExtTypeFromReturnType(method, returnTypePath);
            returnDefinition.enumFullClassName = returnDefinition.type.type == ValueType.EnumRef ? method.getReturnType().getName() : null;
            funcDefinition.returnDefinition = returnDefinition;
        }
        Annotation[][] parameterAnnotations = method.getParameterAnnotations();
        for (int i = 0; i < method.getParameterCount(); ++i) {
            funcDefinition.args.put("a" + i, FuncGroupsDefinitionExtractor.toFuncArgDefinition(method, i, parameterAnnotations[i], path));
        }
        return funcDefinition;
    }

    private static FuncArgDefinition toFuncArgDefinition(Method method, int parameterIndex, Annotation[] parameterAnnotations, String path) {
        FuncArgDefinition funcArgDefinition = new FuncArgDefinition();
        Map<Class, Annotation> map = Arrays.stream(parameterAnnotations).collect(Collectors.toMap(Annotation::annotationType, v -> v));
        FuncParamName parameterName = (FuncParamName)map.get(FuncParamName.class);
        if (parameterName == null) {
            throw new RuntimeException("fHI9cZW64p :: \u043d\u0435\u0442 \u0430\u043d\u043d\u043e\u0442\u0430\u0446\u0438\u0438 FuncParamName \u0443 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 \u0441 \u0438\u043d\u0434\u0435\u043a\u0441\u043e\u043c " + parameterIndex + " \u0443 \u043c\u0435\u0442\u043e\u0434\u0430 " + method.getName());
        }
        FuncParamDescription parameterDescription = (FuncParamDescription)map.get(FuncParamDescription.class);
        if (parameterDescription == null) {
            throw new RuntimeException("eJm1ZCOw57 :: \u043d\u0435\u0442 \u0430\u043d\u043d\u043e\u0442\u0430\u0446\u0438\u0438 FuncParamDescription \u0443 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 \u0441 \u0438\u043d\u0434\u0435\u043a\u0441\u043e\u043c " + parameterIndex + " \u0443 \u043c\u0435\u0442\u043e\u0434\u0430 " + method.getName());
        }
        FuncParamNewLine parameterNewLine = (FuncParamNewLine)map.get(FuncParamNewLine.class);
        FuncParamNullable parameterNullable = (FuncParamNullable)map.get(FuncParamNullable.class);
        Parameter parameter = method.getParameters()[parameterIndex];
        Class<?> type = parameter.getType();
        funcArgDefinition.name = parameterName.value();
        funcArgDefinition.enumFullClassName = type.isEnum() ? type.getName() : null;
        funcArgDefinition.description = parameterDescription.value();
        funcArgDefinition.nativeIndex = parameterIndex;
        funcArgDefinition.type = FuncGroupsDefinitionExtractor.toValueExtTypeFromMethodParameter(parameter, path);
        funcArgDefinition.newLine = parameterNewLine == null ? false : parameterNewLine.value();
        funcArgDefinition.nullable = parameterNullable == null ? false : parameterNullable.value();
        return funcArgDefinition;
    }

    private static ValueExtType toValueExtTypeFromReturnType(Method sourceMethod, String path) {
        Class<?> methodReturnClass = sourceMethod.getReturnType();
        ValueExtType valueExtType = ValueExtTypeUtil.fromSimpleToValueExtType(methodReturnClass);
        if (valueExtType != null) {
            return valueExtType;
        }
        valueExtType = FuncGroupsDefinitionExtractor.getValueExtTypeFromObjects(methodReturnClass);
        if (valueExtType != null) {
            return valueExtType;
        }
        Annotation[] annotations = sourceMethod.getAnnotatedReturnType().getAnnotations();
        Map<Class, Annotation> annotationMap = Arrays.stream(annotations).collect(Collectors.toMap(Annotation::annotationType, v -> v));
        if (Objects.equals(BoiRef.class, methodReturnClass)) {
            FuncReturnType funcReturnType = (FuncReturnType)annotationMap.get(FuncReturnType.class);
            if (funcReturnType == null) {
                throw new RuntimeException("FJGFqPP11O :: \u043d\u0435\u0442 \u0430\u043d\u043d\u043e\u0442\u0430\u0446\u0438\u0438 FuncReturnType \u0443 \u0432\u043e\u0437\u0432\u0440\u0430\u0449\u0430\u0435\u043c\u043e\u0433\u043e \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u0430 \u0434\u043b\u044f \u043a\u043b\u0430\u0441\u0441\u0430 " + methodReturnClass.getSimpleName() + ", \u043c\u0435\u0442\u043e\u0434: " + path);
            }
            return ValueExtType.single(funcReturnType.value());
        }
        if (List.class.equals(methodReturnClass)) {
            Type[] types = ((ParameterizedType)sourceMethod.getAnnotatedReturnType().getType()).getActualTypeArguments();
            if (types.length != 1) {
                throw new RuntimeException("0NKCsQYlZS :: \u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043f\u0440\u043e\u0447\u0438\u0442\u0430\u0442\u044c generic class List-\u0430");
            }
            Type type = types[0];
            if (!(type instanceof Class)) {
                throw new RuntimeException("KRWo5yeh1M :: Cannot cast type into class");
            }
            Class innerGenericClass = (Class)type;
            if (BoiRef.class.equals((Object)innerGenericClass)) {
                FuncReturnType funcReturnType = (FuncReturnType)annotationMap.get(FuncReturnType.class);
                if (funcReturnType == null) {
                    throw new RuntimeException("FJGFqPP11O :: \u043d\u0435\u0442 \u0430\u043d\u043d\u043e\u0442\u0430\u0446\u0438\u0438 FuncReturnType \u0443 \u0432\u043e\u0437\u0432\u0440\u0430\u0449\u0430\u0435\u043c\u043e\u0433\u043e \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u0430 \u0434\u043b\u044f \u043a\u043b\u0430\u0441\u0441\u0430 " + methodReturnClass.getSimpleName() + ", \u043c\u0435\u0442\u043e\u0434: " + path);
                }
                return ValueExtType.multiple(funcReturnType.value());
            }
            ValueExtType innerValueExtType = ValueExtTypeUtil.fromSimpleToValueExtType(innerGenericClass);
            if (innerValueExtType != null) {
                innerValueExtType.isArray = true;
                return innerValueExtType;
            }
            innerValueExtType = FuncGroupsDefinitionExtractor.getValueExtTypeFromObjects(innerGenericClass);
            if (innerValueExtType != null) {
                innerValueExtType.isArray = true;
                return innerValueExtType;
            }
        }
        throw new RuntimeException("o9U0zaLyOy :: \u041e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u0447\u0438\u043a \u0434\u043b\u044f \u043a\u043b\u0430\u0441\u0441\u0430 : " + methodReturnClass.getSimpleName() + ", \u043f\u0443\u0442\u044c: " + path);
    }

    private static ValueExtType toValueExtTypeFromMethodParameter(Parameter sourceParameter, String path) {
        Class<?> methodParameterClass = sourceParameter.getType();
        ValueExtType valueExtType = ValueExtTypeUtil.fromSimpleToValueExtType(methodParameterClass);
        if (valueExtType != null) {
            return valueExtType;
        }
        valueExtType = FuncGroupsDefinitionExtractor.getValueExtTypeFromObjects(methodParameterClass);
        if (valueExtType != null) {
            return valueExtType;
        }
        Annotation[] annotations = sourceParameter.getAnnotations();
        Map<Class, Annotation> annotationMap = Arrays.stream(annotations).collect(Collectors.toMap(Annotation::annotationType, v -> v));
        if (Objects.equals(BoiRef.class, methodParameterClass)) {
            FuncParamType funcParamType = (FuncParamType)annotationMap.get(FuncParamType.class);
            if (funcParamType == null) {
                throw new RuntimeException("FJGFqPP11O :: \u043d\u0435\u0442 \u0430\u043d\u043d\u043e\u0442\u0430\u0446\u0438\u0438 FuncParamType \u0443 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 \u0434\u043b\u044f \u043a\u043b\u0430\u0441\u0441\u0430 " + methodParameterClass.getSimpleName() + ", \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440: " + path);
            }
            return ValueExtType.single(funcParamType.value());
        }
        if (List.class.equals(methodParameterClass)) {
            Type[] types = ((ParameterizedType)sourceParameter.getParameterizedType()).getActualTypeArguments();
            if (types.length != 1) {
                throw new RuntimeException("sd1i31A2QC :: \u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043f\u0440\u043e\u0447\u0438\u0442\u0430\u0442\u044c generic class List-\u0430");
            }
            Type type = types[0];
            if (!(type instanceof Class)) {
                throw new RuntimeException("k5TQl5V55v :: Cannot cast type into class");
            }
            Class innerGenericClass = (Class)type;
            if (BoiRef.class.equals((Object)innerGenericClass)) {
                FuncParamType funcParamType = (FuncParamType)annotationMap.get(FuncParamType.class);
                if (funcParamType == null) {
                    throw new RuntimeException("29Or7ASy50 :: \u043d\u0435\u0442 \u0430\u043d\u043d\u043e\u0442\u0430\u0446\u0438\u0438 FuncParamType \u0443 \u0432\u043e\u0437\u0432\u0440\u0430\u0449\u0430\u0435\u043c\u043e\u0433\u043e \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u0430 \u0434\u043b\u044f \u043a\u043b\u0430\u0441\u0441\u0430 " + methodParameterClass.getSimpleName() + ", \u043c\u0435\u0442\u043e\u0434: " + path);
                }
                return ValueExtType.multiple(funcParamType.value());
            }
            ValueExtType innerValueExtType = ValueExtTypeUtil.fromSimpleToValueExtType(innerGenericClass);
            if (innerValueExtType != null) {
                innerValueExtType.isArray = true;
                return innerValueExtType;
            }
            innerValueExtType = FuncGroupsDefinitionExtractor.getValueExtTypeFromObjects(innerGenericClass);
            if (innerValueExtType != null) {
                innerValueExtType.isArray = true;
                return innerValueExtType;
            }
        }
        throw new RuntimeException("o9U0zaLyOy :: \u041e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u0447\u0438\u043a \u0434\u043b\u044f \u043a\u043b\u0430\u0441\u0441\u0430 : " + methodParameterClass.getSimpleName() + ", \u043f\u0443\u0442\u044c: " + path);
    }

    @Nullable
    private static ValueExtType getValueExtTypeFromObjects(Class<?> aClass) {
        ObjectNativeName objectNativeName = aClass.getAnnotation(ObjectNativeName.class);
        if (objectNativeName == null) {
            return null;
        }
        return ValueExtType.object(objectNativeName.value());
    }
}

