/*
 * Decompiled with CFR 0.152.
 */
package kz.greetgo.script.model.expr.flow;

import java.math.BigDecimal;
import kz.greetgo.kafka.model.KafkaModel;
import kz.greetgo.mybpm_util_light.ann.dumping.MixingId;
import kz.greetgo.script.model.context.model.BoiRefCode;
import kz.greetgo.script.model.expr.Expr;
import kz.greetgo.script.model.expr.flow.value.ExprValueType;
import kz.greetgo.script.model.expr.flow.value.GeoPointShowType;
import kz.greetgo.script.model.translate.ValueExtType;

@KafkaModel
public class ExprValue
extends Expr {
    public ExprValueType exprValueType;
    public ValueExtType valueType;
    public String varBlockId;
    public String constType;
    public String value;
    public String boCode;
    public String fieldCode;
    @MixingId
    public String boiId;
    public String objectDescriptor;
    public boolean isTextMultiline;
    public String textareaWidth;
    public String textareaHeight;
    public double latitude;
    public double longitude;
    public GeoPointShowType geoPointShowType;
    public String optionId;
    public static final String JavaObjectFactories = "JavaObjectFactories";

    public static ExprValue thisProcess() {
        ExprValue ret = new ExprValue();
        ret.exprValueType = ExprValueType.THIS_PROCESS;
        return ret;
    }

    public static ExprValue text(String text) {
        ExprValue ret = new ExprValue();
        ret.exprValueType = ExprValueType.CONST;
        ret.valueType = ValueExtType.text();
        ret.constType = String.class.getSimpleName();
        ret.value = text;
        return ret;
    }

    public static ExprValue varRef(String varBlockId) {
        ExprValue ret = new ExprValue();
        ret.exprValueType = ExprValueType.VAR_REF;
        ret.varBlockId = varBlockId;
        return ret;
    }

    public static ExprValue boiRefCode(BoiRefCode boiRefCode) {
        ExprValue ret = new ExprValue();
        ret.exprValueType = ExprValueType.CONST;
        ret.valueType = ValueExtType.boiRefCode(boiRefCode.boCode);
        ret.constType = BoiRefCode.class.getSimpleName();
        ret.boCode = boiRefCode.boCode;
        ret.boiId = boiRefCode.boiId;
        return ret;
    }

    public static Expr number(String number) {
        ExprValue ret = new ExprValue();
        ret.exprValueType = ExprValueType.CONST;
        ret.valueType = ValueExtType.number();
        ret.constType = BigDecimal.class.getSimpleName();
        ret.value = number;
        return ret;
    }

    public static ExprValue javaObjectFactory(String objectDescriptor, ValueExtType resultType) {
        ExprValue ret = new ExprValue();
        ret.exprValueType = ExprValueType.CONST;
        ret.constType = JavaObjectFactories;
        ret.valueType = resultType;
        ret.objectDescriptor = objectDescriptor;
        return ret;
    }

    public String toString() {
        return "ExprValue(exprValueType=" + this.exprValueType + ", valueType=" + this.valueType + ", varBlockId=" + this.varBlockId + ", constType=" + this.constType + ", value=" + this.value + ", boCode=" + this.boCode + ", fieldCode=" + this.fieldCode + ", boiId=" + this.boiId + ", objectDescriptor=" + this.objectDescriptor + ", isTextMultiline=" + this.isTextMultiline + ", textareaWidth=" + this.textareaWidth + ", textareaHeight=" + this.textareaHeight + ", latitude=" + this.latitude + ", longitude=" + this.longitude + ", geoPointShowType=" + this.geoPointShowType + ", optionId=" + this.optionId + ")";
    }

    public static final class Fields {
        public static final String exprValueType = "exprValueType";
        public static final String valueType = "valueType";
        public static final String varBlockId = "varBlockId";
        public static final String constType = "constType";
        public static final String value = "value";
        public static final String boCode = "boCode";
        public static final String fieldCode = "fieldCode";
        public static final String boiId = "boiId";
        public static final String objectDescriptor = "objectDescriptor";
        public static final String isTextMultiline = "isTextMultiline";
        public static final String textareaWidth = "textareaWidth";
        public static final String textareaHeight = "textareaHeight";
        public static final String latitude = "latitude";
        public static final String longitude = "longitude";
        public static final String geoPointShowType = "geoPointShowType";
        public static final String optionId = "optionId";
    }
}

