package kz.greetgo.script.model.block.con;

import java.util.HashMap;
import java.util.Map;
import kz.greetgo.kafka.model.KafkaModel;
import lombok.ToString;

@ToString
@KafkaModel
public class BlockIf extends BlockCon {

  public String ifExprId;

  public String thenBlockId;

  public Map<String, IfBranch> branches = new HashMap<>();

  public static BlockIf of(String ifExprId, String thenBlockId) {
    BlockIf blockIf = new BlockIf();
    blockIf.ifExprId    = ifExprId;
    blockIf.thenBlockId = thenBlockId;
    return blockIf;
  }

  public BlockIf down(String downBlockId) {
    this.downBlockId = downBlockId;
    return this;
  }

  public BlockIf elseIf(String exprId, String blockId) {
    int newOrder = this.branches.values().stream().mapToInt(x -> x.order).max().orElse(0) + 10;

    IfBranch branch = new IfBranch();
    branch.order   = newOrder;
    branch.hasExpr = true;
    branch.exprId  = exprId;
    branch.blockId = blockId;

    branches.put("elseIf" + (branches.size() + 1), branch);

    return this;
  }

  public BlockIf else_(String thenBlockId) {
    int newOrder = this.branches.values().stream().mapToInt(x -> x.order).max().orElse(0) + 10;

    IfBranch branch = new IfBranch();
    branch.order   = newOrder;
    branch.hasExpr = false;
    branch.blockId = thenBlockId;

    branches.put("else" + (branches.size() + 1), branch);

    return this;
  }
}
