package kz.greetgo.script.model.block.con;

import kz.greetgo.kafka.model.KafkaModel;
import kz.greetgo.script.model.block.enums.SetVarType;
import lombok.ToString;

@ToString
@KafkaModel
public class BlockSetVar extends BlockCon {

  /**
   * Тип блока
   */
  public SetVarType varType;

  /**
   * Имя новой переменной.
   * <p>
   * Используется, если {@link #varType} == {@link SetVarType#LocalCreate}
   */
  public String varName;

  /**
   * Идентификатор блока, где определена локальная переменная.
   * <p>
   * Используется, если {@link #varType} == {@link SetVarType#LocalRef}
   */
  public String blockId;

  /**
   * Идентификатор внешней переменной
   * <p>
   * Используется, если {@link #varType} == {@link SetVarType#ExternRef}
   */
  public String externVarId;

  /**
   * Идентификатор выражения, значение которого присваивается переменной в качестве значения
   */
  public String valueExprId;

  public static BlockSetVar externRef(String externVarId, String valueExprId) {
    var a = new BlockSetVar();
    a.varType     = SetVarType.ExternRef;
    a.externVarId = externVarId;
    a.valueExprId = valueExprId;
    return a;
  }

  public static BlockSetVar localCreate(String varName, String valueExprId) {
    var a = new BlockSetVar();
    a.varType     = SetVarType.LocalCreate;
    a.varName     = varName;
    a.valueExprId = valueExprId;
    return a;
  }

  public static BlockSetVar localRef(String blockId, String valueExprId) {
    var a = new BlockSetVar();
    a.varType     = SetVarType.LocalRef;
    a.blockId = blockId;
    a.valueExprId = valueExprId;
    return a;
  }

  public BlockSetVar down(String downBlockId) {
    this.downBlockId = downBlockId;
    return this;
  }
}
