package kz.greetgo.script.model.context;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import kz.greetgo.script.model.context.model.BoiRef;
import kz.greetgo.script.model.context.model.BoiRefCode;
import kz.greetgo.script.model.context.model.GeoPoint;
import kz.greetgo.script.model.context.model.Period;
import kz.greetgo.script.model.context.model.SingleSelectRef;
import kz.greetgo.script.model.context.model.SingleSelectRefCode;
import kz.greetgo.script.model.context.model.VarDef;
import kz.greetgo.script.model.context.model.filter.CtxBoiFilter;
import kz.greetgo.script.model.context.model.signature.MybpmFile;

public interface ScriptContext {

  BoiRef self();

  BoiRefCode thisProcess();

  List<VarDef> getVars(String boId);

  BigDecimal getVarAsBigDecimal(BoiRef boiRef, String fieldId);

  BigDecimal getVarAsBigDecimal(BoiRefCode boiRefCode, String fieldCode);

  String getVarAsText(BoiRef boiRef, String fieldId);

  String getVarAsText(BoiRefCode boiRefCode, String fieldCode);

  boolean getVarAsBool(BoiRef boiRef, String fieldId);

  boolean getVarAsBool(BoiRefCode boiRefCode, String fieldCode);

  Date getVarAsDate(BoiRef boiRef, String fieldId);

  Date getVarAsDate(BoiRefCode boiRefCode, String fieldCode);

  BoiRef getVarAsBoiRef(BoiRef boiRef, String fieldId);

  BoiRefCode getVarAsBoiRef(BoiRefCode boiRefCode, String fieldCode);

  List<BoiRef> getVarAsBoiRefList(BoiRef boiRef, String fieldId);

  List<BoiRefCode> getVarAsBoiRefList(BoiRefCode boiRefCode, String fieldCode);

  SingleSelectRef getVarAsSingleSelectRef(BoiRef boiRef, String fieldId);

  SingleSelectRefCode getVarAsSingleSelectRef(BoiRefCode boiRefCode, String fieldCode);

  GeoPoint getVarAsGeoPointCoordinate(BoiRef boiRef, String fieldId);

  GeoPoint getVarAsGeoPointCoordinate(BoiRefCode boiRefCode, String fieldCode);

  Period getVarAsPeriod(BoiRef boiRef, String fieldId);

  Period getVarAsPeriod(BoiRefCode boiRefCode, String fieldCode);

  MybpmFile getVarAsFile(BoiRef boiRef, String fieldId);

  MybpmFile getVarAsFile(BoiRefCode boiRef, String fieldCode);

  List<MybpmFile> getVarAsFileList(BoiRef boiRef, String fieldId);

  List<MybpmFile> getVarAsFileList(BoiRefCode boiRefCode, String fieldCode);

  void setVarAsBigDecimal(BoiRef boiRef, String fieldId, BigDecimal value);

  void setVarAsBigDecimal(BoiRefCode boiRefCode, String fieldCode, BigDecimal value);

  void setVarAsText(BoiRef boiRef, String fieldId, String value);

  void setVarAsText(BoiRefCode boiRefCode, String fieldCode, String value);

  void setVarAsDate(BoiRef boiRef, String fieldId, Date value);

  void setVarAsDate(BoiRefCode boiRefCode, String fieldCode, Date value);

  void setVarAsBool(BoiRef boiRef, String fieldId, Boolean value);

  void setVarAsBool(BoiRefCode boiRefCode, String fieldCode, Boolean value);

  void setVarAsBoiRef(BoiRef boiRef, String fieldId, BoiRef value);

  void setVarAsBoiRef(BoiRefCode boiRefCode, String fieldCode, BoiRefCode value);

  void setVarAsBoiRefList(BoiRef boiRef, String fieldId, List<BoiRef> value);

  void setVarAsBoiRefList(BoiRefCode boiRefCode, String fieldCode, List<BoiRefCode> value);

  void setVarAsSingleSelectRef(BoiRef boiRef, String fieldId, SingleSelectRef value);

  void setVarAsSingleSelectRef(BoiRefCode boiRefCode, String fieldCode, SingleSelectRefCode value);

  void setVarAsGeoPointCoordinate(BoiRef boiRef, String fieldId, GeoPoint value);

  void setVarAsGeoPointCoordinate(BoiRefCode boiRefCode, String fieldCode, GeoPoint value);

  void setVarAsPeriod(BoiRef boiRef, String fieldId, Period value);

  void setVarAsPeriod(BoiRefCode boiRefCode, String fieldCode, Period value);

  void setVarAsFile(BoiRef boiRef, String fieldId, MybpmFile value);

  void setVarAsFile(BoiRefCode boiRefCode, String fieldCode, MybpmFile value);

  void setVarAsFileList(BoiRef boiRef, String fieldId, List<MybpmFile> value);

  void setVarAsFileList(BoiRefCode boiRefCode, String fieldCode, List<MybpmFile> value);

  /**
   * Поиск инстанций бизнес-объекта по фильтру
   * <p>
   * Если указать limit > 0, то будет возвращаться список с указанным количеством инстанций, не больше.
   * <p>
   * Если указать limit <= 0, то будет возвращаться итератор, который автоматически будет загружать порции данных с сервера
   *
   * @param boId   идентификатор БО, инстанции которого ищутся
   * @param filter фильтр поиска
   * @param skip   сколько нужно вначале пропустить перед выводом
   * @param limit  ограничение вывода
   * @return итератор по найденным инстанциям или список найденных инстанций
   */
  Iterable<BoiRef> findBoi(String boId, CtxBoiFilter filter, int skip, int limit);

  BoiRef createBoi(String boId);

  @SuppressWarnings("unused")
  ScriptFuncContext funcContext();

  @SuppressWarnings("unused")
  ScriptObjectContext objectContext();

  void goForProcess(BoiRef boiRef);

}
