package kz.greetgo.script.model.context.controller.func;

import java.math.BigDecimal;
import java.util.List;
import kz.greetgo.script.ann.func.FuncDescription;
import kz.greetgo.script.ann.func.FuncName;
import kz.greetgo.script.ann.func.FuncParamDescription;
import kz.greetgo.script.ann.func.FuncParamName;
import kz.greetgo.script.ann.func.FuncParamNullable;
import kz.greetgo.script.ann.func.FuncParamType;
import kz.greetgo.script.ann.model.ValueType;
import kz.greetgo.script.model.context.model.BoiRef;
import kz.greetgo.script.model.context.model.signature.MybpmFile;
import org.jetbrains.annotations.Nullable;

@FuncName("Оповещения")
@FuncDescription("Оповещения")
public interface AlertFuncController {

  @FuncName("Отправить email")
  @FuncDescription("Отсылает письмо по указанному адресу")
  void sendEmail(

    @FuncParamName("email")
    @FuncParamType(ValueType.Text)
    @FuncParamDescription("Электронный адрес назначения")
      String email,

    @FuncParamName("заголовок")
    @FuncParamType(ValueType.Text)
    @FuncParamDescription("Заголовок письма")
      String topic,

    @FuncParamName("тело")
    @FuncParamType(ValueType.Text)
    @FuncParamDescription("Тело письма")
      String body,

    @FuncParamName("Вложенные файлы (Опционально)")
    @FuncParamType(ValueType.Object)
    @FuncParamDescription("Вложенные файлы. Использовать этот параметр, если передавамых файлов несколько")
    @FuncParamNullable
    @Nullable
      List<MybpmFile> files

  );

  @FuncName("Уведомление")
  @FuncDescription("Отправляет уведомление в системе")
  void sendPushNotification(

    @FuncParamName("кому")
    @FuncParamType(ValueType.Bo)
    @FuncParamDescription("Указывает кому направить уведомление. Если указать пользователя, то отправиться только ему." +
      " Если указать группу пользователей, то отправиться всем пользователям этой группы." +
      " Если указать департамент, то отправиться всем пользователям в этом департаменте и всем пользователям во всех вложенных" +
      " департаментах рекурсивно до конца")
      BoiRef target,

    @FuncParamName("заголовок")
    @FuncParamType(ValueType.Text)
    @FuncParamDescription("Заголовок уведомления")
      String topic,

    @FuncParamName("тело")
    @FuncParamType(ValueType.Text)
    @FuncParamDescription("Тело уведомления")
      String body,

    @FuncParamName("ссылка (Опционально)")
    @FuncParamType(ValueType.Text)
    @FuncParamDescription("Ссылка уведомлении")
    @FuncParamNullable
    @Nullable
      String url,

    @FuncParamName("аудио (Опционально)")
    @FuncParamType(ValueType.Bool)
    @FuncParamDescription("Нужно ли аудио")
    @FuncParamNullable
    @Nullable
      Boolean needAudio,

    @FuncParamName("длительность (секунд) (Опционально)")
    @FuncParamType(ValueType.Number)
    @FuncParamDescription("Длительность уведомлении в секундах")
    @FuncParamNullable
    @Nullable
      BigDecimal duration

  );

  @FuncName("Email пользователям")
  @FuncDescription("Отправляет электронное письмо пользователям")
  void sendEmailToUsers(

    @FuncParamName("кому")
    @FuncParamType(ValueType.Bo)
    @FuncParamDescription("Указывает кому отправить письмо. Если указать пользователя, то отправиться только ему." +
      " Если указать группу пользователей, то отправиться всем пользователям этой группы." +
      " Если указать департамент, то отправиться всем пользователям в этом департаменте и всем пользователям во всех вложенных" +
      " департаментах рекурсивно до конца")
      BoiRef target,

    @FuncParamName("заголовок")
    @FuncParamType(ValueType.Text)
    @FuncParamDescription("Заголовок письма")
      String topic,

    @FuncParamName("тело")
    @FuncParamType(ValueType.Text)
    @FuncParamDescription("Тело письма")
      String body,

    @FuncParamName("Вложенные файлы (Опционально)")
    @FuncParamType(ValueType.Object)
    @FuncParamDescription("Вложенные файлы. Использовать этот параметр, если передавамых файлов несколько")
    @FuncParamNullable
    @Nullable
      List<MybpmFile> files

  );


}
