package kz.greetgo.script.model.context.controller.func;

import kz.greetgo.script.ann.func.FuncDescription;
import kz.greetgo.script.ann.func.FuncName;
import kz.greetgo.script.ann.func.FuncParamDescription;
import kz.greetgo.script.ann.func.FuncParamName;
import kz.greetgo.script.ann.func.FuncParamNullable;
import kz.greetgo.script.ann.func.FuncParamType;
import kz.greetgo.script.ann.func.FuncReturnDescription;
import kz.greetgo.script.ann.model.ValueType;
import kz.greetgo.script.model.context.model.BoiFieldRef;
import kz.greetgo.script.model.context.model.BoiRef;
import kz.greetgo.script.model.context.model.SingleSelectRef;
import kz.greetgo.script.model.expr.flow.FieldMetaType;

@FuncName("Работа с полями")
@FuncDescription("Работа с полями")
public interface FieldMetaDataFuncController {

  @FuncName("Получить атрибуты поля")
  @FuncDescription("Получить атрибут поля (Чтение/Видимость/Обязательность)")
  @FuncReturnDescription("Возвращает true или false")
  boolean readBoiFieldMeta(

    @FuncParamName("Ссылка на поле")
    @FuncParamDescription("Ссылка на поле")
    BoiFieldRef boiFieldRef,

    @FuncParamName("Для пользователя/рабочей группы/департамента")
    @FuncParamDescription("Ссылка на пользователя/рабочей группы/департамента")
    @FuncParamType(ValueType.Bo)
    BoiRef boiRefOrgUnit,

    @FuncParamName("Тип атрибута")
    @FuncParamDescription("Тип атрибута")
    FieldMetaType fieldMetaType

  );

  @FuncName("Установка атрибутов поля")
  @FuncDescription("Установка атрибутов поля (Чтение/Видимость/Обязательность)")
  void writeBoiFieldMeta(

    @FuncParamName("Ссылка на поле")
    @FuncParamDescription("Ссылка на поле")
    BoiFieldRef boiFieldRef,

    @FuncParamNullable
    @FuncParamName("Для пользователя/рабочей группы/департамента")
    @FuncParamDescription("Ссылка на пользователя/рабочей группы/департамента")
    @FuncParamType(ValueType.Bo)
    BoiRef boiRefOrgUnit,

    @FuncParamName("Тип атрибута")
    @FuncParamDescription("Тип атрибута")
    FieldMetaType fieldMetaType,

    @FuncParamName("Значение")
    @FuncParamDescription("Значение true или false")
    boolean value
  );

  @FuncName("Установка атрибутов формы")
  @FuncDescription("Установка атрибутов формы (Чтение)")
  void writeBoiFormMetaReadonly(

    @FuncParamName("У")
    @FuncParamDescription("Ссылка на инстанцию")
    @FuncParamType(ValueType.Bo)
    BoiRef boiRef,

    @FuncParamNullable
    @FuncParamName("Для пользователя/рабочей группы/департамента")
    @FuncParamDescription("Ссылка на пользователя/рабочей группы/департамента")
    @FuncParamType(ValueType.Bo)
    BoiRef boiRefOrgUnit,

    @FuncParamName("Значение")
    @FuncParamDescription("Значение true или false")
    boolean value
  );

  @FuncName("Установка видимости опции")
  @FuncDescription("Установка видимости опции выпадающего списка")
  void writeBoiFieldOptionShown(

    @FuncParamName("У")
    @FuncParamDescription("Ссылка на инстанцию")
    @FuncParamType(ValueType.Bo)
    BoiRef boiRef,

    @FuncParamName("опция")
    @FuncParamDescription("Ссылка на опцию выпадающего списка")
    SingleSelectRef singleSelectRef,

    @FuncParamName("Для пользователя/рабочей группы/департамента")
    @FuncParamDescription("Ссылка на пользователя/рабочей группы/департамента")
    @FuncParamType(ValueType.Bo)
    BoiRef boiRefOrgUnit,

    @FuncParamName("Значение")
    @FuncParamDescription("Значение true или false")
    boolean value
  );

}
