package kz.greetgo.script.model.context.model;

import lombok.Builder;
import lombok.EqualsAndHashCode;
import lombok.RequiredArgsConstructor;
import lombok.ToString;

/**
 * Самодостаточная ссылка на поле инстанции бизнес-объекта с использованием кодов
 */
@Builder
@ToString
@EqualsAndHashCode
@RequiredArgsConstructor
public class BoiFieldRefCode {

  /**
   * Код бизнес-объекта
   */
  public final String boCode;

  /**
   * Код поля бизнес-объекта
   */
  public final String fieldCode;

  /**
   * Идентификатор инстанции бизнес-объекта
   */
  public final String boiId;

  public static BoiFieldRefCode of(BoiRefCode boiRefCode, String fieldCode) {
    return new BoiFieldRefCode(boiRefCode.boCode, fieldCode, boiRefCode.boiId);
  }
}
