package kz.greetgo.script.model.context.model;

import lombok.Builder;
import lombok.EqualsAndHashCode;
import lombok.RequiredArgsConstructor;
import lombok.ToString;

/**
 * Самодостаточная ссылка на инстанцию бизнес-объекта с использованием кодов
 */
@Builder
@ToString
@EqualsAndHashCode
@RequiredArgsConstructor
public class BoiRefCode {

  /**
   * Код бизнес-объекта
   */
  public final String boCode;

  /**
   * Идентификатор инстанции бизнес-объекта
   */
  public final String boiId;

  public static BoiRefCode of(String boCode, String boiId) {
    return new BoiRefCode(boCode, boiId);
  }
}
