package kz.greetgo.script.model.context.model.signature;

import java.util.List;
import kz.greetgo.script.ann.enums.EnumDescription;
import kz.greetgo.script.ann.enums.EnumName;

@EnumName("Тип документа")
@EnumDescription("Тип документа")
public enum MybpmFileType {

  @EnumName("PDF")
  @EnumDescription("...")
  PDF,

  @EnumName("DOC")
  @EnumDescription("...")
  DOC,

  @EnumName("UNKNOWN")
  @EnumDescription("Неопределенный тип документа")
  UNKNOWN;

  public static MybpmFileType parse(String mimeType) {
    if (mimeType == null) {
      return UNKNOWN;
    }

    mimeType = mimeType.toLowerCase();

    if (isPdf(mimeType)) {
      return PDF;
    } else if (isDoc(mimeType)) {
      return DOC;
    }

    return UNKNOWN;
  }

  private static final List<String> pdfList = List.of("pdf", "application/pdf");

  private static boolean isPdf(String mimeType) {
    return pdfList.contains(mimeType);
  }

  private static final List<String> docList = List.of("doc", "docx", "application/vnd.openxmlformats-officedocument.wordprocessingml.document");

  private static boolean isDoc(String mimeType) {
    return docList.contains(mimeType);
  }

}
