package kz.greetgo.script.model.definitions.func;

import java.util.HashMap;
import java.util.Map;
import lombok.ToString;

import static java.util.stream.Collectors.toMap;

@ToString
public class FuncGroupsDefinition {

  public Map<String, FuncGroupDefinition> groups = new HashMap<>();

  public FuncGroupsDefinition onlyEnabled() {

    FuncGroupsDefinition ret = new FuncGroupsDefinition();

    ret.groups = this.groups.entrySet().stream()
                            .filter(x -> !x.getValue().disabled)
                            .collect(toMap(Map.Entry::getKey, Map.Entry::getValue));

    return ret;
  }

}
