package kz.greetgo.script.model.definitions.func.extractor;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import kz.greetgo.script.ann.func.FuncDescription;
import kz.greetgo.script.ann.func.FuncDisabled;
import kz.greetgo.script.ann.func.FuncName;
import kz.greetgo.script.ann.func.FuncParamDescription;
import kz.greetgo.script.ann.func.FuncParamName;
import kz.greetgo.script.ann.func.FuncParamNewLine;
import kz.greetgo.script.ann.func.FuncParamNullable;
import kz.greetgo.script.ann.func.FuncParamType;
import kz.greetgo.script.ann.func.FuncReturnDescription;
import kz.greetgo.script.ann.func.FuncReturnType;
import kz.greetgo.script.ann.model.ValueType;
import kz.greetgo.script.ann.object.ObjectNativeName;
import kz.greetgo.script.model.context.ScriptFuncContext;
import kz.greetgo.script.model.context.ScriptObjectContext;
import kz.greetgo.script.model.context.model.BoiRef;
import kz.greetgo.script.model.definitions.func.FuncArgDefinition;
import kz.greetgo.script.model.definitions.func.FuncDefinition;
import kz.greetgo.script.model.definitions.func.FuncGroupDefinition;
import kz.greetgo.script.model.definitions.func.FuncGroupsDefinition;
import kz.greetgo.script.model.definitions.func.FuncRetDefinition;
import kz.greetgo.script.model.translate.ValueExtType;
import kz.greetgo.script.model.util.ValueExtTypeUtil;
import org.jetbrains.annotations.Nullable;

import static java.util.stream.Collectors.toMap;

public class FuncGroupsDefinitionExtractor {

  private static final Map<Class<? extends ScriptObjectContext>, FuncGroupsDefinition> cached = new ConcurrentHashMap<>();

  public static void init(Class<? extends ScriptObjectContext> scriptObjectContextClass) {
    loadFuncGroupsDefinition(scriptObjectContextClass);
  }

  public static FuncGroupsDefinition loadFuncGroupsDefinitionTest() {
    return cached.entrySet().stream().findFirst().map(Map.Entry::getValue).orElse(null);//TODO @Anuar remove
  }

  public static FuncGroupsDefinition loadFuncGroupsDefinition(Class<? extends ScriptObjectContext> scriptObjectContextClass) {

    {
      FuncGroupsDefinition fromCache = cached.get(scriptObjectContextClass);
      if (fromCache != null) {
        return fromCache;
      }
    }

    synchronized (cached) {
      FuncGroupsDefinition fromCache = cached.get(scriptObjectContextClass);
      if (fromCache != null) {
        return fromCache;
      }

      FuncGroupsDefinition load = load();

      cached.put(scriptObjectContextClass, load);

      return load;
    }

  }

  private static FuncGroupsDefinition load() {

    FuncGroupsDefinition funcGroupsDefinition = new FuncGroupsDefinition();

    funcGroupsDefinition.groups = Arrays.stream(ScriptFuncContext.class.getDeclaredMethods())
                                        .map(FuncGroupsDefinitionExtractor::extract)
                                        .collect(Collectors.toMap(k -> k.nativeName, v -> v));

    return funcGroupsDefinition;

  }

  private static FuncGroupDefinition extract(Method method) {
    FuncGroupDefinition funcGroupDefinition = new FuncGroupDefinition();

    Class<?> funcController = method.getReturnType();

    FuncName funcName = funcController.getAnnotation(FuncName.class);
    if (funcName == null) {
      throw new RuntimeException("E8IXb15GIa :: Нет аннотации FuncName у класса " + funcController.getSimpleName());
    }

    FuncDescription funcDescription = funcController.getAnnotation(FuncDescription.class);
    if (funcDescription == null) {
      throw new RuntimeException("5d3eMe4t0V :: Нет аннотации FuncDescription у класса " + funcController.getSimpleName());
    }

    FuncDisabled funcDisabled = funcController.getAnnotation(FuncDisabled.class);

    String simpleName = funcController.getSimpleName();

    funcGroupDefinition.name        = funcName.value();
    funcGroupDefinition.description = funcDescription.value();
    funcGroupDefinition.nativeName  = method.getName();
    funcGroupDefinition.disabled    = funcDisabled != null;
    funcGroupDefinition.functions   = Arrays.stream(funcController.getDeclaredMethods())
                                            .map(x -> toFuncDefinition(x, simpleName))
                                            .collect(toMap(k -> k.nativeName, v -> v));

    return funcGroupDefinition;
  }

  private static FuncDefinition toFuncDefinition(Method method, String simpleName) {

    String path = simpleName + "." + method.getName();

    FuncDefinition funcDefinition = new FuncDefinition();

    FuncName funcName = method.getAnnotation(FuncName.class);
    if (funcName == null) {
      throw new RuntimeException("VSxCD4nMtd :: Нет аннотации FuncName у метода " + path);
    }

    FuncDescription funcDescription = method.getAnnotation(FuncDescription.class);
    if (funcDescription == null) {
      throw new RuntimeException("K2mrzDfn1R :: Нет аннотации FuncDescription у метода " + path);
    }

    funcDefinition.name        = funcName.value();
    funcDefinition.description = funcDescription.value();
    funcDefinition.nativeName  = method.getName();

    if (method.getGenericReturnType() != Void.TYPE) {

      FuncReturnDescription funcReturnDescription = method.getAnnotation(FuncReturnDescription.class);
      if (funcReturnDescription == null) {
        throw new RuntimeException("MOlWeUE4n8 :: Нет аннотации FuncReturnDescription у возвращаемого элемента, метода " + path);
      }

      String returnTypePath = path + " return type ";

      FuncRetDefinition returnDefinition = new FuncRetDefinition();
      returnDefinition.description = funcReturnDescription.value();
      returnDefinition.type        = toValueExtTypeFromReturnType(method, returnTypePath);

      returnDefinition.enumFullClassName = returnDefinition.type.type == ValueType.EnumRef ? method.getReturnType().getName() : null;

      funcDefinition.returnDefinition = returnDefinition;
    }

    Annotation[][] parameterAnnotations = method.getParameterAnnotations();

    for (int i = 0; i < method.getParameterCount(); i++) {
      funcDefinition.args.put("a" + i, toFuncArgDefinition(method, i, parameterAnnotations[i], path));
    }

    return funcDefinition;

  }

  private static FuncArgDefinition toFuncArgDefinition(Method method,
                                                       int parameterIndex,
                                                       Annotation[] parameterAnnotations,
                                                       String path) {

    FuncArgDefinition funcArgDefinition = new FuncArgDefinition();

    var map = Arrays.stream(parameterAnnotations).collect(toMap(Annotation::annotationType, v -> v));

    FuncParamName parameterName = (FuncParamName) map.get(FuncParamName.class);
    if (parameterName == null) {
      throw new RuntimeException("fHI9cZW64p :: нет аннотации FuncParamName у параметра с индексом " + parameterIndex
                                   + " у метода " + method.getName());
    }

    FuncParamDescription parameterDescription = (FuncParamDescription) map.get(FuncParamDescription.class);
    if (parameterDescription == null) {
      throw new RuntimeException("eJm1ZCOw57 :: нет аннотации FuncParamDescription у параметра с индексом " + parameterIndex
                                   + " у метода " + method.getName());
    }

    FuncParamNewLine  parameterNewLine  = (FuncParamNewLine) map.get(FuncParamNewLine.class);
    FuncParamNullable parameterNullable = (FuncParamNullable) map.get(FuncParamNullable.class);

    Parameter parameter = method.getParameters()[parameterIndex];

    Class<?> type = parameter.getType();

    funcArgDefinition.name              = parameterName.value();
    funcArgDefinition.enumFullClassName = type.isEnum() ? type.getName() : null;
    funcArgDefinition.description       = parameterDescription.value();
    funcArgDefinition.nativeIndex       = parameterIndex;
    funcArgDefinition.type              = toValueExtTypeFromMethodParameter(parameter, path);
    funcArgDefinition.newLine           = parameterNewLine == null ? false : parameterNewLine.value();
    funcArgDefinition.nullable          = parameterNullable == null ? false : parameterNullable.value();

    return funcArgDefinition;

  }

  private static ValueExtType toValueExtTypeFromReturnType(Method sourceMethod, String path) {

    Class<?> methodReturnClass = sourceMethod.getReturnType();

    ValueExtType valueExtType = ValueExtTypeUtil.fromSimpleToValueExtType(methodReturnClass);
    if (valueExtType != null) {
      return valueExtType;
    }

    valueExtType = getValueExtTypeFromObjects(methodReturnClass);
    if (valueExtType != null) {
      return valueExtType;
    }

    Annotation[] annotations = sourceMethod.getAnnotatedReturnType().getAnnotations();

    Map<? extends Class<? extends Annotation>, Annotation> annotationMap =
      Arrays.stream(annotations).collect(toMap(Annotation::annotationType, v -> v));

    if (Objects.equals(BoiRef.class, methodReturnClass)) {
      FuncReturnType funcReturnType = (FuncReturnType) annotationMap.get(FuncReturnType.class);
      if (funcReturnType == null) {
        throw new RuntimeException(
          "FJGFqPP11O :: нет аннотации FuncReturnType у возвращаемого элемента для класса " + methodReturnClass.getSimpleName()
            + ", метод: " + path);
      }
      return ValueExtType.single(funcReturnType.value());
    }

    if (List.class.equals(methodReturnClass)) {

      Type[] types = ((ParameterizedType) (sourceMethod.getAnnotatedReturnType().getType())).getActualTypeArguments();

      if (types.length != 1) {
        throw new RuntimeException("0NKCsQYlZS :: Невозможно прочитать generic class List-а");
      }

      Type type = types[0];

      if (!(type instanceof Class)) {
        throw new RuntimeException("KRWo5yeh1M :: Cannot cast type into class");
      }

      Class<?> innerGenericClass = (Class<?>) type;

      if (BoiRef.class.equals(innerGenericClass)) {
        FuncReturnType funcReturnType = (FuncReturnType) annotationMap.get(FuncReturnType.class);
        if (funcReturnType == null) {
          throw new RuntimeException(
            "FJGFqPP11O :: нет аннотации FuncReturnType у возвращаемого элемента для класса " + methodReturnClass.getSimpleName()
              + ", метод: " + path);
        }
        return ValueExtType.multiple(funcReturnType.value());
      }

      ValueExtType innerValueExtType = ValueExtTypeUtil.fromSimpleToValueExtType(innerGenericClass);
      if (innerValueExtType != null) {
        innerValueExtType.isArray = true;
        return innerValueExtType;
      }

      innerValueExtType = getValueExtTypeFromObjects(innerGenericClass);
      if (innerValueExtType != null) {
        innerValueExtType.isArray = true;
        return innerValueExtType;
      }

    }

    throw new RuntimeException("o9U0zaLyOy :: Отсутствует обработчик для класса : " + methodReturnClass.getSimpleName() + ", путь: " + path);
  }

  private static ValueExtType toValueExtTypeFromMethodParameter(Parameter sourceParameter, String path) {

    Class<?> methodParameterClass = sourceParameter.getType();

    ValueExtType valueExtType = ValueExtTypeUtil.fromSimpleToValueExtType(methodParameterClass);
    if (valueExtType != null) {
      return valueExtType;
    }

    valueExtType = getValueExtTypeFromObjects(methodParameterClass);
    if (valueExtType != null) {
      return valueExtType;
    }

    Annotation[] annotations = sourceParameter.getAnnotations();

    Map<? extends Class<? extends Annotation>, Annotation> annotationMap = Arrays.stream(annotations).collect(
      toMap(Annotation::annotationType, v -> v));

    if (Objects.equals(BoiRef.class, methodParameterClass)) {
      FuncParamType funcParamType = (FuncParamType) annotationMap.get(FuncParamType.class);
      if (funcParamType == null) {
        throw new RuntimeException("FJGFqPP11O :: нет аннотации FuncParamType у параметра для класса " + methodParameterClass.getSimpleName()
                                     + ", параметр: " + path);
      }
      return ValueExtType.single(funcParamType.value());
    }

    if (List.class.equals(methodParameterClass)) {

      Type[] types = ((ParameterizedType) (sourceParameter.getParameterizedType())).getActualTypeArguments();

      if (types.length != 1) {
        throw new RuntimeException("sd1i31A2QC :: Невозможно прочитать generic class List-а");
      }

      Type type = types[0];

      if (!(type instanceof Class)) {
        throw new RuntimeException("k5TQl5V55v :: Cannot cast type into class");
      }

      Class<?> innerGenericClass = (Class<?>) type;

      if (BoiRef.class.equals(innerGenericClass)) {
        FuncParamType funcParamType = (FuncParamType) annotationMap.get(FuncParamType.class);
        if (funcParamType == null) {
          throw new RuntimeException(
            "29Or7ASy50 :: нет аннотации FuncParamType у возвращаемого элемента для класса " + methodParameterClass.getSimpleName()
              + ", метод: " + path);
        }
        return ValueExtType.multiple(funcParamType.value());
      }

      ValueExtType innerValueExtType = ValueExtTypeUtil.fromSimpleToValueExtType(innerGenericClass);
      if (innerValueExtType != null) {
        innerValueExtType.isArray = true;
        return innerValueExtType;
      }

      innerValueExtType = getValueExtTypeFromObjects(innerGenericClass);
      if (innerValueExtType != null) {
        innerValueExtType.isArray = true;
        return innerValueExtType;
      }

    }

    throw new RuntimeException("o9U0zaLyOy :: Отсутствует обработчик для класса : " + methodParameterClass.getSimpleName() + ", путь: " + path);
  }

  @Nullable
  private static ValueExtType getValueExtTypeFromObjects(Class<?> aClass) {

    ObjectNativeName objectNativeName = aClass.getAnnotation(ObjectNativeName.class);
    if (objectNativeName == null) {
      return null;
    }

    return ValueExtType.object(objectNativeName.value());
  }

}
