package kz.greetgo.script.model.translate;

import java.util.Objects;
import java.util.Set;
import kz.greetgo.script.ann.model.ValueType;
import lombok.EqualsAndHashCode;

@EqualsAndHashCode
public class ValueExtType {
  public ValueType   type;
  public boolean     isArray;
  public String      boId;
  public String      fieldId;
  public String      coId;
  public Set<String> containingBoIds;
  public String      instanceBoId;
  public String      instanceBoiId;
  public String      instanceBoiName;
  public String      objectId;

  public String enumNativeName;

  public boolean isPersonBo;

  public ValueExtType asAlone() {
    ValueExtType ret = new ValueExtType();
    ret.type    = type;
    ret.isArray = false;
    ret.boId    = boId;
    ret.coId    = coId;
    if (containingBoIds != null) {
      ret.containingBoIds = Set.copyOf(containingBoIds);
    }
    return ret;
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder(getClass().getSimpleName() + '{');
    sb.append(isArray ? "ARR " : "ONE ").append(type);
    if (boId != null) {
      sb.append(", boId=").append(boId);
    }
    if (coId != null) {
      sb.append(", coId=").append(coId);
    }
    if (fieldId != null) {
      sb.append(", fieldId=").append(fieldId);
    }
    if (containingBoIds != null) {
      sb.append(", containingBoIds=").append(containingBoIds);
    }
    return sb.append('}').toString();
  }

  public static ValueExtType single(ValueType valueType) {
    final ValueExtType ret = new ValueExtType();
    ret.type    = valueType;
    ret.isArray = false;
    return ret;
  }

  public static ValueExtType multiple(ValueType valueType) {
    final ValueExtType ret = new ValueExtType();
    ret.type    = valueType;
    ret.isArray = true;
    return ret;
  }

  public static ValueExtType bo(String boId, boolean isArray) {
    final ValueExtType ret = new ValueExtType();
    ret.type    = ValueType.Bo;
    ret.isArray = isArray;
    ret.boId    = boId;
    return ret;
  }

  public static ValueExtType co(String coId, boolean isArray, Set<String> containingBoIds) {
    final ValueExtType ret = new ValueExtType();
    ret.type            = ValueType.Co;
    ret.isArray         = isArray;
    ret.coId            = coId;
    ret.containingBoIds = containingBoIds;
    return ret;
  }

  public String extractBoId() {
    if (type == ValueType.Bo) {
      return boId;
    }
    if (type == ValueType.Co) {
      return coId;
    }
    return null;
  }

  public static ValueExtType singleSelect(String boId, String fieldId) {
    ValueExtType ret = new ValueExtType();
    ret.type    = ValueType.SingleSelect;
    ret.boId    = boId;
    ret.fieldId = fieldId;
    ret.isArray = false;
    return ret;
  }

  public static ValueExtType enumRef(String enumNativeName) {
    ValueExtType single = single(ValueType.EnumRef);
    single.enumNativeName = enumNativeName;
    return single;
  }

  public static ValueExtType tab() {
    return single(ValueType.Tab);
  }

  public static ValueExtType object(String objectId) {
    ValueExtType single = single(ValueType.Object);
    single.objectId = objectId;
    return single;
  }

  public static boolean eq(ValueExtType extType1, ValueExtType extType2) {
    if (extType1 == null && extType2 == null) {
      return true;
    }
    if (extType1 == null || extType2 == null) {
      return false;
    }

    ValueType type = extType1.type;

    if (type != extType2.type) {
      if (type == ValueType.Bo && extType2.type == ValueType.Co) {

        return extType2.containingBoIds.contains(extType1.boId);

      } else if (type == ValueType.Co && extType2.type == ValueType.Bo) {

        return extType1.containingBoIds.contains(extType2.boId);

      } else {
        return false;
      }
    }

    if (type == null) {
      return true;
    }

    switch (type) {

      case Bo:
        return Objects.equals(extType1.boId, extType2.boId);

      case Co:
        return Objects.equals(extType1.boId, extType2.boId) && Objects.equals(extType1.containingBoIds, extType2.containingBoIds);

      case Object:
        return Objects.equals(extType1.objectId, extType2.objectId);

      case EnumRef:
        return Objects.equals(extType1.enumNativeName, extType2.enumNativeName);

      case BoField:
        return Objects.equals(extType1.boId, extType2.boId) && Objects.equals(extType1.fieldId, extType2.fieldId);

      case SingleSelect:
        return true;

      default:
        return true;
    }
  }

  public static boolean eqBoCo(ValueExtType extType1, ValueExtType extType2) {

    if (extType1 == null && extType2 == null) {
      return true;
    }
    if (extType1 == null || extType2 == null) {
      return false;
    }

    ValueType type = extType1.type;

    if (type != extType2.type) {
      if (type == ValueType.Bo && extType2.type == ValueType.Co) {

        return extType2.containingBoIds.contains(extType1.boId);

      } else if (type == ValueType.Co && extType2.type == ValueType.Bo) {

        return extType1.containingBoIds.contains(extType2.boId);

      }
    }

    return eq(extType1, extType2);
  }

}
