package kz.greetgo.script.model.util;

import java.math.BigDecimal;
import java.util.Date;
import kz.greetgo.script.ann.model.ValueType;
import kz.greetgo.script.model.context.model.BoiFieldRef;
import kz.greetgo.script.model.context.model.GeoPoint;
import kz.greetgo.script.model.context.model.Period;
import kz.greetgo.script.model.context.model.SingleSelectRef;
import kz.greetgo.script.model.context.model.signature.MybpmFile;
import kz.greetgo.script.model.translate.ValueExtType;

public class ValueExtTypeUtil {

  public static ValueExtType fromSimpleToValueExtType(Class<?> aClass) {

    if (String.class.equals(aClass)) {
      return ValueExtType.single(ValueType.Text);
    }
    if (BigDecimal.class.equals(aClass)) {
      return ValueExtType.single(ValueType.Number);
    }
    if (Boolean.class.equals(aClass) || boolean.class.equals(aClass)) {
      return ValueExtType.single(ValueType.Bool);
    }
    if (Date.class.equals(aClass)) {
      return ValueExtType.single(ValueType.Date);
    }
    if (Period.class.equals(aClass)) {
      return ValueExtType.single(ValueType.Period);
    }
    if (GeoPoint.class.equals(aClass)) {
      return ValueExtType.single(ValueType.GeoPoint);
    }
    if (SingleSelectRef.class.equals(aClass)) {
      return ValueExtType.single(ValueType.SingleSelect);
    }
    if (BoiFieldRef.class.equals(aClass)) {
      return ValueExtType.single(ValueType.BoField);
    }
    if (MybpmFile.class.equals(aClass)) {
      return ValueExtType.multiple(ValueType.File);
    }
    if (aClass.isEnum()) {
      ValueExtType valueExtType = ValueExtType.single(ValueType.EnumRef);
      valueExtType.enumNativeName = aClass.getSimpleName();
      return valueExtType;
    }

    return null;

  }

}
