/*
 * Decompiled with CFR 0.152.
 */
package kz.greetgo.num_translator.mappers;

import java.util.HashMap;
import kz.greetgo.num_translator.languages.Language;
import kz.greetgo.num_translator.mappers.IBlockMapper;
import kz.greetgo.num_translator.mappers.ThreeDigitsBlock;

public class KazBlockMapper
implements IBlockMapper {
    private static final HashMap<Integer, String> unitToWordsKaz = new HashMap<Integer, String>(){
        {
            this.put(0, "\u043d\u04e9\u043b");
            this.put(1, "\u0431\u0456\u0440");
            this.put(2, "\u0435\u043a\u0456");
            this.put(3, "\u04af\u0448");
            this.put(4, "\u0442\u04e9\u0440\u0442");
            this.put(5, "\u0431\u0435\u0441");
            this.put(6, "\u0430\u043b\u0442\u044b");
            this.put(7, "\u0436\u0435\u0442\u0456");
            this.put(8, "\u0441\u0435\u0433\u0456\u0437");
            this.put(9, "\u0442\u043e\u0493\u044b\u0437");
        }
    };
    private static final HashMap<Integer, String> decimalsInWordsKaz = new HashMap<Integer, String>(){
        {
            this.put(1, "\u043e\u043d");
            this.put(2, "\u0436\u0438\u044b\u0440\u043c\u0430");
            this.put(3, "\u043e\u0442\u044b\u0437");
            this.put(4, "\u049b\u044b\u0440\u044b\u049b");
            this.put(5, "\u0435\u043b\u0443");
            this.put(6, "\u0430\u043b\u043f\u044b\u0441");
            this.put(7, "\u0436\u0435\u0442\u043f\u0456\u0441");
            this.put(8, "\u0441\u0435\u043a\u0441\u0435\u043d");
            this.put(9, "\u0442\u043e\u049b\u0441\u0430\u043d");
        }
    };
    private static final HashMap<Language, String> hundredBlockNameMapper = new HashMap<Language, String>(){
        {
            this.put(Language.KAZ, " \u0436\u04af\u0437");
        }
    };

    @Override
    public String unitToWordsMapper(ThreeDigitsBlock num) {
        return unitToWordsKaz.get(num.getUnits());
    }

    @Override
    public String decimalToWordsMapper(ThreeDigitsBlock num) {
        return decimalsInWordsKaz.get(num.getDecimals());
    }

    @Override
    public String hundredToWordsMapper(ThreeDigitsBlock num) {
        return unitToWordsKaz.get(num.getHundreds()) + hundredBlockNameMapper.get((Object)Language.KAZ);
    }
}

